package com.xebialabs.satellite.streaming

import akka.stream.scaladsl.Flow
import akka.stream.stage.{TerminationDirective, Context, PushStage}
import akka.util.ByteString

object ErrorStage {

  type Handler = Throwable => Unit

  def flow(onError: Handler) = Flow[ByteString].transform(() => handlingErrorStage(onError))

  def handlingErrorStage(onError: Handler) = new PushStage[ByteString, ByteString] {
    override def onPush(elem: ByteString, ctx: Context[ByteString]) = ctx.push(elem)

    override def onUpstreamFailure(cause: Throwable, ctx: Context[ByteString]): TerminationDirective = {
      onError(cause)
      super.onUpstreamFailure(cause, ctx)
    }
  }
}
