package com.xebialabs.satellite.protocol

import com.xebialabs.deployit.engine.tasker.TaskId

case object GetInstalledPlugins

case class InstalledPlugins(plugins: Set[String])

case class ReplacePluginsFromTask(taskId: TaskId)

case object MaintenanceEvent

case object RestartSatellite
case object GetSatelliteStatus

sealed trait SatelliteStatus
case object Restarting extends SatelliteStatus
case class WaitingRestart(runningTasks: Seq[TaskId]) extends SatelliteStatus
case class SatelliteRunning(since: Long) extends SatelliteStatus
