package com.xebialabs.satellite.serialization

import java.io.File
import java.nio.file.Paths

import com.xebialabs.satellite.protocol.UploadFileForTask

case class UploadedFiles(workdir: String, files: Map[ArtifactId, UploadFileForTask]) extends (ArtifactId => File) {

  def apply(artifactId: ArtifactId): File = files(artifactId).filePath(workdir).toFile
}
