package com.xebialabs.xlplatform.test.jcr;

import java.io.File;
import java.io.IOException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.util.GuavaFiles;

import static java.lang.Thread.sleep;

/**
 */
public class JcrTestHelper {

    private File jackrabbitDir;
    private JackrabbitRepositoryFactoryBean repositoryFactoryBean;
    private String configurationFile = "jackrabbit-repository.xml";
    private Repository repository;

    private JcrTemplate jcrTemplate;

    private final ServerConfiguration deployitConfig;

    public JcrTestHelper(ServerConfiguration deployitConfig) {
        this.deployitConfig = deployitConfig;
    }

    public JcrTestHelper(ServerConfiguration deployitConfig, final String configurationFile) {
        this.deployitConfig = deployitConfig;
        this.configurationFile = configurationFile;
    }

    public void setupJackrabbit() throws RepositoryException, IOException {
        jackrabbitDir = File.createTempFile("jackrabbit", "repo");
        jackrabbitDir.delete();
        jackrabbitDir.mkdir();

        String homeDirAbsolutePath = jackrabbitDir.getAbsolutePath();

        repositoryFactoryBean = new JackrabbitRepositoryFactoryBean();
        repositoryFactoryBean.setConfiguration(new ClassPathResource(configurationFile));
        repositoryFactoryBean.setHomeDir(new FileSystemResource(homeDirAbsolutePath));
        repositoryFactoryBean.setAutoInitialize(true);
        repositoryFactoryBean.setDeployitConfig(deployitConfig);
        repositoryFactoryBean.afterPropertiesSet();
        repository = repositoryFactoryBean.getObject();

        jcrTemplate = new JcrTemplate(repository, deployitConfig);
    }

    public void shutdownJackrabbit() {
        repositoryFactoryBean.destroy();
        waitForShutdown();
        deleteDirectory();
    }

    private void deleteDirectory() {
        try {
            GuavaFiles.deleteRecursively(jackrabbitDir);
        } catch (IOException e) {
            // IGNORE
        }
    }

    private void waitForShutdown() {
        try {
            sleep(1000);
        } catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    public Repository getRepository() {
        return repository;
    }

    public JcrTemplate getJcrTemplate() {
        return jcrTemplate;
    }

}
