/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.test.jcr;

import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.test.jcr.JcrTestHelper;
import javax.crypto.SecretKey;
import javax.jcr.RepositoryException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;

public abstract class JcrTestBase {
    protected static JcrTestHelper jcrTestHelper;
    protected static JcrTemplate jcrTemplate;

    @BeforeClass
    public static void setupJcrRepository() throws Exception, RepositoryException {
        LocalBooter.bootWithoutGlobalContext();
        PasswordEncrypter.init((SecretKey)DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY);
        ServerConfiguration deployitConfig = new ServerConfigFile(new ClassPathResource("deployit.conf").getFile()).loadConfig();
        jcrTestHelper = new JcrTestHelper(deployitConfig);
        jcrTestHelper.setupJackrabbit();
        jcrTemplate = jcrTestHelper.getJcrTemplate();
        new JcrTemplateHolder(jcrTemplate);
        SecurityTemplate.setAuthentication((Authentication)new TestingAuthenticationToken((Object)"admin", (Object)"admin", new String[]{"ROLE_ADMIN"}));
    }

    @AfterClass
    public static void shutdownJcrRepository() {
        jcrTestHelper.shutdownJackrabbit();
    }
}

