package com.xebialabs.xlplatform.test.jcr;

import javax.jcr.RepositoryException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.authentication.TestingAuthenticationToken;

import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;

public abstract class JcrTestBase {

    protected static JcrTestHelper jcrTestHelper;

    protected static JcrTemplate jcrTemplate;

    @BeforeClass
    public static void setupJcrRepository() throws Exception, RepositoryException {
        LocalBooter.bootWithoutGlobalContext();
        PasswordEncrypter.init(DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY);
        ServerConfiguration deployitConfig = new ServerConfigFile(new ClassPathResource("deployit.conf").getFile()).loadConfig();
        jcrTestHelper = new JcrTestHelper(deployitConfig);
        jcrTestHelper.setupJackrabbit();
        jcrTemplate = jcrTestHelper.getJcrTemplate();
        new JcrTemplateHolder(jcrTemplate);
        SecurityTemplate.setAuthentication(new TestingAuthenticationToken("admin", "admin", "ROLE_ADMIN"));

    }

    @AfterClass
    public static void shutdownJcrRepository() {
        jcrTestHelper.shutdownJackrabbit();
    }
}
