/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.test.jcr;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.File;
import java.io.IOException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class JcrTestHelper {
    private File jackrabbitDir;
    private JackrabbitRepositoryFactoryBean repositoryFactoryBean;
    private String configurationFile = "jackrabbit-repository.xml";
    private Repository repository;
    private JcrTemplate jcrTemplate;
    private final ServerConfiguration deployitConfig;

    public JcrTestHelper(ServerConfiguration deployitConfig) {
        this.deployitConfig = deployitConfig;
    }

    public JcrTestHelper(ServerConfiguration deployitConfig, String configurationFile) {
        this.deployitConfig = deployitConfig;
        this.configurationFile = configurationFile;
    }

    public void setupJackrabbit() throws RepositoryException, IOException {
        this.jackrabbitDir = File.createTempFile("jackrabbit", "repo");
        this.jackrabbitDir.delete();
        this.jackrabbitDir.mkdir();
        String homeDirAbsolutePath = this.jackrabbitDir.getAbsolutePath();
        this.repositoryFactoryBean = new JackrabbitRepositoryFactoryBean();
        this.repositoryFactoryBean.setConfiguration((Resource)new ClassPathResource(this.configurationFile));
        this.repositoryFactoryBean.setHomeDir((Resource)new FileSystemResource(homeDirAbsolutePath));
        this.repositoryFactoryBean.setAutoInitialize(true);
        this.repositoryFactoryBean.setDeployitConfig(this.deployitConfig);
        this.repositoryFactoryBean.afterPropertiesSet();
        this.repository = this.repositoryFactoryBean.getObject();
        this.jcrTemplate = new JcrTemplate(this.repository, this.deployitConfig);
    }

    public void shutdownJackrabbit() {
        this.repositoryFactoryBean.destroy();
        this.waitForShutdown();
        this.deleteDirectory();
    }

    private void deleteDirectory() {
        try {
            GuavaFiles.deleteRecursively((File)this.jackrabbitDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void waitForShutdown() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public JcrTemplate getJcrTemplate() {
        return this.jcrTemplate;
    }
}

