/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;

public abstract class ResourceTestUtils {
    private ResourceTestUtils() {
    }

    public static String getResourceAsString(String resourceName, Charset charset) throws IOException {
        ClassLoader loader = ResourceTestUtils.firstNonNull(Thread.currentThread().getContextClassLoader(), ResourceTestUtils.class.getClassLoader());
        String res = null;
        try (InputStream fileStream = loader.getResourceAsStream(resourceName);){
            if (null == fileStream) {
                throw new IllegalArgumentException(String.format("resource %s not found.", resourceName));
            }
            try (InputStreamReader isr = new InputStreamReader(fileStream, charset);){
                StringWriter sw = new StringWriter();
                char[] buf = new char[4096];
                int len = 0;
                while ((len = isr.read(buf)) != -1) {
                    sw.write(buf, 0, len);
                    sw.flush();
                }
                res = sw.toString();
            }
        }
        return res;
    }

    public static String getResourceAsString(String resourceName) throws IOException {
        return ResourceTestUtils.getResourceAsString(resourceName, Charset.forName("UTF-8"));
    }

    public static URL getResource(String resourceName) {
        ClassLoader loader = ResourceTestUtils.firstNonNull(Thread.currentThread().getContextClassLoader(), ResourceTestUtils.class.getClassLoader());
        URL url = loader.getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException(String.format("resource %s not found.", resourceName));
        }
        return url;
    }

    private static <T> T firstNonNull(T first, T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException();
    }
}

