package com.xebialabs.xlplatform.extensions.exportcis.route

import akka.actor.ActorSystem
import com.typesafe.config.ConfigFactory
import com.xebialabs.deployit.repository.RepositoryServiceHolder.getRepositoryService
import com.xebialabs.xlplatform.endpoints.{AuthenticatedData, ExtensionRoutes}
import com.xebialabs.xlplatform.extensions.exportcis.CisExportSupport
import com.xebialabs.xlplatform.extensions.exportcis.archive.RepositoryExporter.RepositoryRootAlias
import de.schlichtherle.truezip.util.UriDecoder
import grizzled.slf4j.Logging
import spray.http.{HttpResponse, StatusCodes}

import scalax.file.Path

class ExportCisRoute extends ExtensionRoutes with Logging with CisExportSupport {

  private val defaultExportDir = ConfigFactory.load("extensions.conf").getString("export-cis.export-dir")

  private val uriDecoder = new UriDecoder()

  def route(system: ActorSystem) = (auth: AuthenticatedData) => pathPrefix("export" / "citree") {
    post {
      path(Rest){ ciIdEncoded =>
        rejectNonAdmin(auth) {
          val ciId = uriDecoder.decode(ciIdEncoded)
          parameter('exportDir.?(defaultExportDir)) { exportDir =>
            logger.info(s"Trying to export CI tree starting from $ciId into $exportDir")
            complete(ciId match {
              case "/" | "" => export(RepositoryRootAlias, Path.fromString(exportDir))(auth)
              case _ if getRepositoryService.exists(ciId) => export(ciId, Path.fromString(exportDir))(auth)
              case _ => HttpResponse(StatusCodes.NotFound, s"CI does not exist [$ciId]")
            })
          }
        }
      }
    }
  }
}
