package com.xebialabs.xlplatform.extensions.exportcis

import com.xebialabs.deployit.plugin.api.flow.{ExecutionContext, Step, StepExitCode}
import com.xebialabs.deployit.repository.{WorkDirContext, RepositoryService}
import com.xebialabs.deployit.repository.RepositoryServiceHolder._
import com.xebialabs.xlplatform.endpoints.{AuthenticatedData, ServicesSupport}
import com.xebialabs.xlplatform.extensions.exportcis.archive.RepositoryImporter
import grizzled.slf4j.Logging

import scala.collection.JavaConversions._
import scala.util.{Failure, Success}
import scalax.file.Path
import scalax.file.defaultfs.DefaultPath

trait CisImportSupport extends ServicesSupport with Logging {

  def `import`(archive: DefaultPath)(implicit auth: AuthenticatedData): String = {
    WorkDirContext.initWorkdir("import")
    taskCreationService.createWithStepBlock(
      auth.toAuthentication,
      s"Import configuration items from '$archive'",
      List(ImportStep(archive)),
      Map("from" -> archive.path)
    )
  }
}

case class ImportStep(archive: DefaultPath) extends Step with Logging {

  override def execute(ctx: ExecutionContext): StepExitCode =
    new RepositoryImporter(getRepositoryService, ctx).`import`(archive) match {
      case Success(_) => StepExitCode.SUCCESS
      case Failure(e) =>
        logger.error(s"Failed to import $archive", e)
        StepExitCode.FAIL
    }

  override def getDescription: String = s"Import configuration items from '$archive'"
  override def getOrder: Int = Step.DEFAULT_ORDER
}