package com.xebialabs.xlplatform.extensions.exportcis.route

import java.io.File

import akka.actor.ActorSystem
import com.xebialabs.xlplatform.endpoints.{AuthenticatedData, ExtensionRoutes}
import com.xebialabs.xlplatform.extensions.exportcis.CisImportSupport
import grizzled.slf4j.Logging
import spray.http.{HttpResponse, StatusCodes}

import scalax.file.ImplicitConversions.jfile2path

class ImportCisRoute extends ExtensionRoutes with Logging with CisImportSupport {

  def route(system: ActorSystem) = (auth: AuthenticatedData) => pathPrefix("import" / "citree") {
    post {
      rejectNonAdmin(auth) {
        parameter('from) { archiveLocation =>
          complete {
            new File(archiveLocation) match {
              case archiveFile if archiveFile.isFile => `import`(archiveFile)(auth)
              case _ => HttpResponse(StatusCodes.NotFound, s"Could not find an archive at [$archiveLocation]")
            }
          }
        }
      }
    }
  }

}
