package com.xebialabs.xlplatform.extensions.exportcis.route

import java.io.File

import com.xebialabs.xlplatform.endpoints.AuthenticatedData
import com.xebialabs.xlplatform.extensions.exportcis.CisImportSupport
import grizzled.slf4j.Logging
import spray.http.{HttpResponse, StatusCodes}
import spray.routing.HttpService

import scalax.file.ImplicitConversions.jfile2path

trait ImportCisRoute extends HttpService with Logging with CisImportSupport {

  val route = (auth: AuthenticatedData) => pathPrefix("import" / "citree") {
    post {
      rejectNonAdmin(auth) {
        parameter('from) { archiveLocation =>
          complete {
            new File(archiveLocation) match {
              case archiveFile if archiveFile.isFile => `import`(archiveFile)(auth)
              case _ => HttpResponse(StatusCodes.NotFound, s"Could not find an archive at [$archiveLocation]")
            }
          }
        }
      }
    }
  }

}
