package com.xebialabs.xlplatform.upgrade.sql.db

import com.xebialabs.xlplatform.repository.sql.Database
import slick.jdbc.JdbcProfile

object MigrationsSchema {

  abstract class Table(val TABLE: String)

  object VERSION extends Table("XL_VERSION") {
    val component: String = "COMPONENT"
    val version: String = "VERSION"
  }

}

object Tables {

  lazy val profile: JdbcProfile = Database.databaseType.profile

  import profile.api._

  case class Version(component: String, version: String)

  class Versions(tag: Tag) extends Table[Version](tag, MigrationsSchema.VERSION.TABLE) {

    def component = column[String](MigrationsSchema.VERSION.component, O.PrimaryKey)

    def version = column[String](MigrationsSchema.VERSION.version)

    def * = (component, version) <> (Version.tupled, Version.unapply)
  }

  val versions = TableQuery[Versions]

}