package com.xebialabs.xlplatform.upgrade.sql

import java.util

import com.xebialabs.deployit.server.api.upgrade.{RepoType, RepositoryInitialization}
import com.xebialabs.deployit.upgrade.InitializationStrategy
import grizzled.slf4j.Logging

import scala.jdk.CollectionConverters._

class SqlInitializationStrategy extends InitializationStrategy with Logging {

  override def findApplicableInitializerTypes(): util.Set[Class[_ <: RepositoryInitialization]] =
    InitializationStrategy.findApplicableInitializerTypes(RepoType.SQL)

  override def doInitializations(initializations: util.List[RepositoryInitialization]): Unit = {
    initializations.asScala.foreach { initialization =>
      logger.debug(s"Running initialization [$initialization] of component [${initialization.getComponent}]")
      initialization.doInitialize()
    }
  }
}
