/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.rest.doclet;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.xebialabs.commons.html.Element;
import com.xebialabs.rest.doclet.RestdocWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RestServiceWriter
extends RestdocWriter {
    private final ClassDoc service;
    private final String path;
    private final String defaultConsumes;
    private final String defaultProduces;

    public RestServiceWriter(PrintWriter writer, ClassDoc service) {
        super(writer);
        this.service = service;
        this.path = RestServiceWriter.getPath((ProgramElementDoc)service);
        this.defaultConsumes = RestServiceWriter.getConsumes((ProgramElementDoc)service);
        this.defaultProduces = RestServiceWriter.getProduces((ProgramElementDoc)service);
    }

    public void writeRestService() {
        this.writeHeader();
        this.writeIndex();
        this.writeMethodDetails();
    }

    private void writeHeader() {
        this.h1(new Object[]{this.service.name()}).write();
        this.p(new Object[]{this.asText(this.service.inlineTags())}).write();
    }

    private void writeIndex() {
        this.table(new Object[0]).cssClass("parameter-table").writeOpen();
        for (MethodDoc method : RestServiceWriter.getRestMethods(this.service)) {
            String httpMethod = RestServiceWriter.getHttpMethod((ProgramElementDoc)method);
            this.row(new Object[]{httpMethod, this.link("#" + this.getAnchor((ProgramElementDoc)method), new Object[]{this.getUri((ProgramElementDoc)method)}), this.asText(method.firstSentenceTags())}).write();
        }
        this.table(new Object[0]).writeClose();
    }

    private void writeMethodDetails() {
        this.hr().write();
        for (MethodDoc method : RestServiceWriter.getRestMethods(this.service)) {
            this.writeMethodDetail(method);
        }
    }

    private void writeMethodDetail(MethodDoc method) {
        this.anchor(this.getAnchor((ProgramElementDoc)method), new Object[0]).write();
        this.h2(new Object[]{RestServiceWriter.getHttpMethod((ProgramElementDoc)method), " ", this.getUri((ProgramElementDoc)method)}).cssClass("resource-header").write();
        this.div(new Object[]{this.asText(method.inlineTags())}).write();
        this.writePermissions(method);
        this.writeParameters(method);
        this.writeReturnType(method);
        for (Tag seeTag : method.tags("see")) {
            this.definitionList("See", new Object[]{this.asText(seeTag.inlineTags())}).write();
        }
    }

    private void writePermissions(MethodDoc method) {
        Tag[] permissions = method.tags("permission");
        if (permissions.length > 0) {
            Element dt = this.definitionList("Permissions", new Object[0]);
            for (Tag permission : permissions) {
                String rest = RestServiceWriter.restOfSentence(permission);
                if (!Strings.isNullOrEmpty((String)rest)) {
                    rest = " - " + rest;
                }
                dt.add(new Object[]{this.element("dd", new Object[]{this.code(new Object[]{RestServiceWriter.firstWord(permission)}), rest})});
            }
            dt.write();
        }
    }

    private void writeReturnType(MethodDoc method) {
        if ("void".equals(method.returnType().simpleTypeName())) {
            this.definitionList("Response body", new Object[]{this.italic(new Object[]{"Empty"})}).write();
        } else {
            this.definitionList("Response body", new Object[]{this.renderType(method.returnType()) + this.getReturnTypeInfo(method), "Content type: " + this.getMethodProduces(method)}).write();
        }
    }

    private String getReturnTypeInfo(MethodDoc method) {
        Tag[] tags = method.tags("return");
        if (tags.length == 0) {
            return "";
        }
        return " - " + this.asText(tags[0].inlineTags());
    }

    private void writeParameters(MethodDoc method) {
        if (method.paramTags().length <= 0) {
            return;
        }
        Element table = this.table(new Object[0]).cssClass("parameter-table");
        for (ParamTag param : method.paramTags()) {
            ParameterInfo info = this.getParameterInfo(method, param);
            if (info == null) {
                System.out.println("Warning: No actual parameter for @param " + param.parameterName() + " on " + method);
                continue;
            }
            table.add(new Object[]{this.row(new Object[]{this.italic(new Object[]{info.kind}), info.name, this.renderType(info.type), this.asText(param.inlineTags())})});
        }
        this.definitionList("Parameters", new Object[]{table}).write();
    }

    private static List<MethodDoc> getRestMethods(ClassDoc service) {
        ArrayList<MethodDoc> methods = new ArrayList<MethodDoc>();
        for (MethodDoc method : service.methods()) {
            if (!RestServiceWriter.isRestMethod(method)) continue;
            methods.add(method);
        }
        Collections.sort(methods, new MethodComparator());
        return methods;
    }

    private static boolean isRestMethod(MethodDoc method) {
        for (AnnotationDesc annotation : method.annotations()) {
            if (!annotation.annotationType().qualifiedName().startsWith("javax.ws.rs")) continue;
            return true;
        }
        return false;
    }

    private static String getPath(ProgramElementDoc element) {
        return RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Path");
    }

    private String getUri(ProgramElementDoc element) {
        return this.path + "/" + RestServiceWriter.getPath(element);
    }

    private String getAnchor(ProgramElementDoc element) {
        return this.getUri(element) + ":" + RestServiceWriter.getHttpMethod(element);
    }

    private static String getConsumes(ProgramElementDoc element) {
        return RestServiceWriter.noJsonSupport(RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Consumes").replace("\"", ""));
    }

    private String getMethodConsumes(MethodDoc method) {
        String consumes = RestServiceWriter.getConsumes((ProgramElementDoc)method);
        if (Strings.isNullOrEmpty((String)consumes)) {
            return this.defaultConsumes;
        }
        return consumes;
    }

    private static String getProduces(ProgramElementDoc element) {
        return RestServiceWriter.noJsonSupport(RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Produces").replace("\"", ""));
    }

    private static String noJsonSupport(String contentTypes) {
        return contentTypes.replace("application/json", "").replaceAll(",\\s*$", "");
    }

    private String getMethodProduces(MethodDoc method) {
        String produces = RestServiceWriter.getProduces((ProgramElementDoc)method);
        if (Strings.isNullOrEmpty((String)produces)) {
            return this.defaultProduces;
        }
        return produces;
    }

    private static String getHttpMethod(ProgramElementDoc element) {
        for (AnnotationDesc annotation : element.annotations()) {
            if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.GET")) {
                return "GET";
            }
            if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.POST")) {
                return "POST";
            }
            if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.PUT")) {
                return "PUT";
            }
            if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.DELETE")) {
                return "DELETE";
            }
            if (!annotation.annotationType().qualifiedName().equals("javax.ws.rs.HEAD")) continue;
            return "HEAD";
        }
        return "?";
    }

    public static String getAnnotationValue(ProgramElementDoc element, String annotationType) {
        return RestServiceWriter.getAnnotationValue(RestServiceWriter.getAnnotation(element, annotationType));
    }

    private static String getAnnotationValue(AnnotationDesc annotation) {
        if (annotation == null) {
            return "";
        }
        int i$ = 0;
        AnnotationDesc.ElementValuePair[] arr$ = annotation.elementValues();
        int len$ = arr$.length;
        if (i$ < len$) {
            AnnotationDesc.ElementValuePair item = arr$[i$];
            Object value = item.value().value();
            if (value instanceof Object[]) {
                return Joiner.on((String)", ").join((Object[])value);
            }
            return value.toString();
        }
        return "";
    }

    private static AnnotationDesc getAnnotation(ProgramElementDoc element, String type) {
        for (AnnotationDesc annotation : element.annotations()) {
            if (!annotation.annotationType().qualifiedName().equals(type)) continue;
            return annotation;
        }
        return null;
    }

    private ParameterInfo getParameterInfo(MethodDoc method, ParamTag tag) {
        String name = tag.parameterName();
        for (Parameter param : method.parameters()) {
            if (!param.name().equals(name)) continue;
            Type type = param.type();
            for (AnnotationDesc annotation : param.annotations()) {
                if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.PathParam")) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotation), "Path", type);
                }
                if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.QueryParam")) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotation), "Query", type);
                }
                if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.HeaderParam")) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotation), "Header", type);
                }
                if (!annotation.annotationType().qualifiedName().equals("org.jboss.resteasy.annotations.providers.multipart.MultipartForm")) continue;
                return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotation), "Multipart", type);
            }
            return new ParameterInfo(this.getMethodConsumes(method), "Request&nbsp;body", type);
        }
        return null;
    }

    private static class MethodComparator
    implements Comparator<MethodDoc> {
        private MethodComparator() {
        }

        @Override
        public int compare(MethodDoc method, MethodDoc anotherMethod) {
            return RestServiceWriter.getPath((ProgramElementDoc)method).compareTo(RestServiceWriter.getPath((ProgramElementDoc)anotherMethod));
        }
    }

    private static class ParameterInfo {
        final String name;
        final String kind;
        final Type type;

        ParameterInfo(String name, String kind, Type type) {
            this.name = name;
            this.kind = kind;
            this.type = type;
        }
    }
}

