/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.rest.doclet;

import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class Resource
implements InputSupplier<InputStream> {
    static final int BUFFER = 2048;

    public void write(PrintWriter writer) {
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getInput()));
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                writer.println(line);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read resource " + this.getName(), e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public void unzip(File destinationDir) {
        try {
            ZipEntry entry;
            destinationDir.mkdirs();
            BufferedOutputStream dest = null;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(this.getInput()));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                File file = new File(destinationDir, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(file);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void copy(File destination) {
        try {
            Files.copy((InputSupplier)this, (File)destination);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public abstract InputStream getInput();

    public abstract String getName();

    public static Resource classpathResource(final String name) {
        return new Resource(){

            @Override
            public InputStream getInput() {
                return Resource.class.getClassLoader().getResourceAsStream(name);
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public static Resource file(final File file) {
        return new Resource(){

            @Override
            public InputStream getInput() {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException("Can't open " + this.getName(), e);
                }
            }

            @Override
            public String getName() {
                return file.getAbsolutePath();
            }
        };
    }
}

