/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.rest.doclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.xebialabs.rest.doclet.FileCatalog;
import com.xebialabs.rest.doclet.OverviewWriter;
import com.xebialabs.rest.doclet.PageTemplate;
import com.xebialabs.rest.doclet.Resource;
import com.xebialabs.rest.doclet.RestServiceWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class RestDoclet {
    private static File destinationDir = new File(".");

    public static int optionLength(String option) {
        return 2;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        for (String[] optionList : options) {
            if (!optionList[0].equals("-d")) continue;
            destinationDir = new File(optionList[1]);
        }
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static boolean start(RootDoc root) {
        List<ClassDoc> restServices = RestDoclet.findRestServices(root);
        RestDoclet.copyCss();
        RestDoclet.writeOverview(restServices);
        RestDoclet.writeServices(restServices);
        RestDoclet.writeLinkedFiles();
        return true;
    }

    private static void copyCss() {
        Resource.classpathResource("restdoc/layout.css").copy(new File(destinationDir, "layout.css"));
        Resource.classpathResource("restdoc/restdoc.css").copy(new File(destinationDir, "restdoc.css"));
        Resource.classpathResource("restdoc/image.zip").unzip(destinationDir);
    }

    private static List<ClassDoc> findRestServices(RootDoc root) {
        ArrayList<ClassDoc> restServices = new ArrayList<ClassDoc>();
        for (ClassDoc classDoc : root.classes()) {
            if (!RestDoclet.isRestService(classDoc)) continue;
            restServices.add(classDoc);
        }
        return restServices;
    }

    private static boolean isRestService(ClassDoc classDoc) {
        for (AnnotationDesc annotation : classDoc.annotations()) {
            if (!annotation.annotationType().qualifiedName().equals("javax.ws.rs.Path")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOverview(List<ClassDoc> restServices) {
        PrintWriter writer = RestDoclet.openFile("index.html", "Deployit REST API");
        try {
            new OverviewWriter(writer).write(restServices);
        }
        finally {
            RestDoclet.closeFile(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeServices(List<ClassDoc> restServices) {
        for (ClassDoc service : restServices) {
            FileCatalog.SINGLETON.add(RestDoclet.fileNameFor((Type)service));
        }
        for (ClassDoc service : restServices) {
            PrintWriter writer = RestDoclet.openFile(RestDoclet.fileNameFor((Type)service), service.name());
            try {
                new RestServiceWriter(writer, service).writeRestService();
            }
            finally {
                RestDoclet.closeFile(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLinkedFiles() {
        for (String item : FileCatalog.SINGLETON.getItems()) {
            if (!FileCatalog.isResource(item)) continue;
            PrintWriter writer = RestDoclet.openFile(item, item.replace(".html", ""));
            try {
                FileCatalog.write(writer, item);
            }
            finally {
                RestDoclet.closeFile(writer);
            }
        }
        for (String item : FileCatalog.SINGLETON.getMissing()) {
            System.out.println("Missing cross reference: " + item);
        }
    }

    public static String fileNameFor(Type service) {
        if (service == null) {
            return null;
        }
        return service.qualifiedTypeName() + ".html";
    }

    public static PrintWriter openFile(String fileName, String title) {
        File file = new File(destinationDir, fileName);
        System.out.println("Writing " + file.getAbsolutePath());
        try {
            PrintWriter writer = new PrintWriter(file);
            new PageTemplate(writer).writeHeader(title);
            return writer;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Can't open " + file.getAbsolutePath() + " for writing.");
        }
    }

    public static void closeFile(PrintWriter writer) {
        new PageTemplate(writer).writeFooter();
        writer.flush();
        writer.close();
    }
}

