/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.rest.doclet;

import com.google.common.base.Strings;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.xebialabs.commons.html.Element;
import com.xebialabs.rest.doclet.FileCatalog;
import com.xebialabs.rest.doclet.JavadocWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RestServiceWriter
extends JavadocWriter {
    private final ClassDoc service;
    private final String path;
    private final String defaultConsumes;
    private final String defaultProduces;

    public RestServiceWriter(PrintWriter writer, ClassDoc service) {
        super(writer);
        this.service = service;
        this.path = RestServiceWriter.getPath((ProgramElementDoc)service);
        this.defaultConsumes = RestServiceWriter.getConsumes((ProgramElementDoc)service);
        this.defaultProduces = RestServiceWriter.getProduces((ProgramElementDoc)service);
    }

    public void writeRestService() {
        this.writeHeader();
        this.writeIndex();
        this.writeDetails();
    }

    private void writeHeader() {
        this.h1(new Object[]{this.service.name()}).write();
        this.p(new Object[]{this.asText(this.service.inlineTags())}).write();
    }

    private void writeIndex() {
        this.table(new Object[0]).cssClass("parameter-table").writeOpen();
        for (MethodDoc method : RestServiceWriter.getRestMethods(this.service)) {
            String httpMethod = RestServiceWriter.getHttpMethod((ProgramElementDoc)method);
            String resource = this.path + "/" + RestServiceWriter.getPath((ProgramElementDoc)method);
            this.row(new Object[]{httpMethod, this.link("#" + method.qualifiedName(), new Object[]{resource}), this.asText(method.firstSentenceTags())}).write();
        }
        this.table(new Object[0]).writeClose();
    }

    private void writeDetails() {
        this.hr().write();
        for (MethodDoc method : RestServiceWriter.getRestMethods(this.service)) {
            this.writeMethodDetail(method, this.path);
        }
    }

    private void writeMethodDetail(MethodDoc method, String path) {
        String httpMethod = RestServiceWriter.getHttpMethod((ProgramElementDoc)method);
        String resource = path + "/" + RestServiceWriter.getPath((ProgramElementDoc)method);
        this.anchor(method.qualifiedName(), new Object[0]).write();
        this.h2(new Object[]{httpMethod, " ", resource}).cssClass("resource-header").write();
        this.div(new Object[]{this.asText(method.inlineTags())}).write();
        this.writePermissions(method);
        this.writeParameters(method);
        this.writeReturnType(method);
        for (Tag seeTag : method.tags("see")) {
            this.definitionList("See", new Object[]{this.asText(seeTag.inlineTags())}).write();
        }
    }

    private void writePermissions(MethodDoc method) {
        Tag[] permissions = method.tags("permission");
        if (permissions.length > 0) {
            Element dt = this.definitionList("Permissions", new Object[0]);
            for (Tag permission : permissions) {
                dt.add(new Object[]{this.element("dd", new Object[]{this.code(new Object[]{permission.text()})})});
            }
            dt.write();
        }
    }

    private void writeReturnType(MethodDoc method) {
        if ("void".equals(method.returnType().simpleTypeName())) {
            this.definitionList("Response body", new Object[]{this.italic(new Object[]{"Empty"})}).write();
        } else {
            this.definitionList("Response body", new Object[]{this.renderType(method.returnType()) + " - " + this.asText(method.tags("return")[0].inlineTags()), "Content type: " + this.getMethodProduces(method)}).write();
        }
    }

    private Object renderType(Type type) {
        String returnTypeText = this.asText(type);
        String externalFile = this.asReference(type);
        if (FileCatalog.SINGLETON.check(externalFile)) {
            returnTypeText = this.link(externalFile, new Object[]{returnTypeText});
        }
        for (Type paramType : this.getParameterizedTypes(type)) {
            FileCatalog.SINGLETON.check(this.asReference(paramType));
        }
        return returnTypeText;
    }

    private void writeParameters(MethodDoc method) {
        if (method.paramTags().length <= 0) {
            return;
        }
        Element table = this.table(new Object[0]).cssClass("parameter-table");
        for (ParamTag param : method.paramTags()) {
            ParameterInfo info = this.getParameterInfo(method, param);
            if (info == null) {
                System.out.println("Warning: No actual parameter for @param " + param.parameterName() + " on " + method);
                continue;
            }
            table.add(new Object[]{this.row(new Object[]{this.italic(new Object[]{info.kind}), info.name, this.renderType(info.type), this.asText(param.inlineTags())})});
        }
        this.definitionList("Parameters", new Object[]{table}).write();
    }

    private static List<MethodDoc> getRestMethods(ClassDoc service) {
        ArrayList<MethodDoc> methods = new ArrayList<MethodDoc>();
        for (MethodDoc method : service.methods()) {
            if (!RestServiceWriter.isRestMethod(method)) continue;
            methods.add(method);
        }
        Collections.sort(methods, new MethodComparator());
        return methods;
    }

    private static boolean isRestMethod(MethodDoc method) {
        for (AnnotationDesc annotation : method.annotations()) {
            if (!annotation.annotationType().qualifiedName().startsWith("javax.ws.rs")) continue;
            return true;
        }
        return false;
    }

    private static String getPath(ProgramElementDoc element) {
        return RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Path");
    }

    private static String getConsumes(ProgramElementDoc element) {
        return RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Consumes").replace("\"", "").replaceAll("[\"\\]\\[]", "");
    }

    private String getMethodConsumes(MethodDoc method) {
        String consumes = RestServiceWriter.getConsumes((ProgramElementDoc)method);
        if (Strings.isNullOrEmpty((String)consumes)) {
            return this.defaultConsumes;
        }
        return consumes;
    }

    private static String getProduces(ProgramElementDoc element) {
        return RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Produces").replaceAll("[\"\\]\\[]", "");
    }

    private String getMethodProduces(MethodDoc method) {
        String produces = RestServiceWriter.getProduces((ProgramElementDoc)method);
        if (Strings.isNullOrEmpty((String)produces)) {
            return this.defaultProduces;
        }
        return produces;
    }

    private static String getHttpMethod(ProgramElementDoc element) {
        for (AnnotationDesc annotation : element.annotations()) {
            if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.GET")) {
                return "GET";
            }
            if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.POST")) {
                return "POST";
            }
            if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.PUT")) {
                return "PUT";
            }
            if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.DELETE")) {
                return "DELETE";
            }
            if (!annotation.annotationType().qualifiedName().equals("javax.ws.rs.HEAD")) continue;
            return "HEAD";
        }
        return "?";
    }

    public static String getAnnotationValue(ProgramElementDoc element, String annotationType) {
        return RestServiceWriter.getAnnotationValue(RestServiceWriter.getAnnotation(element, annotationType));
    }

    private static String getAnnotationValue(AnnotationDesc annotation) {
        if (annotation == null) {
            return "";
        }
        int i$ = 0;
        AnnotationDesc.ElementValuePair[] arr$ = annotation.elementValues();
        int len$ = arr$.length;
        if (i$ < len$) {
            AnnotationDesc.ElementValuePair item = arr$[i$];
            Object value = item.value().value();
            if (value instanceof Object[]) {
                return Arrays.asList((Object[])value).toString();
            }
            return value.toString();
        }
        return "";
    }

    private static AnnotationDesc getAnnotation(ProgramElementDoc element, String type) {
        for (AnnotationDesc annotation : element.annotations()) {
            if (!annotation.annotationType().qualifiedName().equals(type)) continue;
            return annotation;
        }
        return null;
    }

    private ParameterInfo getParameterInfo(MethodDoc method, ParamTag tag) {
        String name = tag.parameterName();
        for (Parameter param : method.parameters()) {
            if (!param.name().equals(name)) continue;
            Type type = param.type();
            for (AnnotationDesc annotation : param.annotations()) {
                if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.PathParam")) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotation), "Path", type);
                }
                if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.QueryParam")) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotation), "Query", type);
                }
                if (annotation.annotationType().qualifiedName().equals("javax.ws.rs.HeaderParam")) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotation), "Header", type);
                }
                if (!annotation.annotationType().qualifiedName().equals("org.jboss.resteasy.annotations.providers.multipart.MultipartForm")) continue;
                return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotation), "Multipart", type);
            }
            return new ParameterInfo(this.getMethodConsumes(method), "Request&nbsp;body", type);
        }
        return null;
    }

    private static class MethodComparator
    implements Comparator<MethodDoc> {
        private MethodComparator() {
        }

        @Override
        public int compare(MethodDoc method, MethodDoc anotherMethod) {
            return RestServiceWriter.getPath((ProgramElementDoc)method).compareTo(RestServiceWriter.getPath((ProgramElementDoc)anotherMethod));
        }
    }

    private static class ParameterInfo {
        final String name;
        final String kind;
        final Type type;

        ParameterInfo(String name, String kind, Type type) {
            this.name = name;
            this.kind = kind;
            this.type = type;
        }
    }
}

