/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.itest;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.google.common.collect.Lists;
import com.xebialabs.itest.ItestHost;
import com.xebialabs.itest.ItestHostFactory;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Ec2ItestHost
implements ItestHost {
    private final String hostLabel;
    private final String amiId;
    private final String awsEndpointURL;
    private final String awsAccessKey;
    private final String awsSecretKey;
    private final String amiAvailabilityZone;
    private final String amiInstanceType;
    private final String amiSecurityGroup;
    private final String amiKeyName;
    private final int amiBootSeconds;
    private AmazonEC2Client ec2;
    private String instanceId;
    private String publicDnsAddress;
    private static final Logger logger = LoggerFactory.getLogger(Ec2ItestHost.class);

    public Ec2ItestHost(String hostLabel, String amiId) {
        this.hostLabel = hostLabel;
        this.amiId = amiId;
        this.awsEndpointURL = ItestHostFactory.getItestProperty("aws.endpoint", "https://ec2.amazonaws.com");
        this.awsAccessKey = ItestHostFactory.getRequiredItestProperty("aws.accessKey");
        this.awsSecretKey = ItestHostFactory.getRequiredItestProperty("aws.secretKey");
        this.amiAvailabilityZone = ItestHostFactory.getItestProperty(".amiAvailabilityZone", null);
        this.amiInstanceType = ItestHostFactory.getRequiredItestProperty(hostLabel + ".amiInstanceType");
        this.amiSecurityGroup = ItestHostFactory.getRequiredItestProperty(hostLabel + ".amiSecurityGroup");
        this.amiKeyName = ItestHostFactory.getRequiredItestProperty(hostLabel + ".amiKeyName");
        this.amiBootSeconds = Integer.valueOf(ItestHostFactory.getRequiredItestProperty(hostLabel + ".amiBootSeconds"));
        this.ec2 = new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(this.awsAccessKey, this.awsSecretKey));
        this.ec2.setEndpoint(this.awsEndpointURL);
    }

    @Override
    public void setup() {
        this.instanceId = this.runInstance();
        this.publicDnsAddress = this.waitUntilRunningAndGetPublicDnsName();
        this.setInstanceName();
        this.waitForAmiBoot();
    }

    @Override
    public void teardown() {
        this.ec2.terminateInstances(new TerminateInstancesRequest((List)Lists.newArrayList((Object[])new String[]{this.instanceId})));
    }

    @Override
    public String getHostName() {
        return this.publicDnsAddress;
    }

    @Override
    public int getPort(int port) {
        return port;
    }

    protected String runInstance() {
        RunInstancesRequest run = new RunInstancesRequest(this.amiId, Integer.valueOf(1), Integer.valueOf(1));
        run.withInstanceInitiatedShutdownBehavior("terminate");
        if (this.amiInstanceType != null) {
            run.withInstanceType(this.amiInstanceType);
        }
        if (this.amiSecurityGroup != null) {
            run.withSecurityGroups(new String[]{this.amiSecurityGroup});
        }
        if (this.amiKeyName != null) {
            run.withKeyName(this.amiKeyName);
        }
        if (this.amiAvailabilityZone != null) {
            run.withPlacement(new Placement(this.amiAvailabilityZone));
        }
        RunInstancesResult result = this.ec2.runInstances(run);
        return ((Instance)result.getReservation().getInstances().get(0)).getInstanceId();
    }

    protected void setInstanceName() {
        this.ec2.createTags(new CreateTagsRequest((List)Lists.newArrayList((Object[])new String[]{this.instanceId}), (List)Lists.newArrayList((Object[])new Tag[]{new Tag("Name", this.hostLabel + " started at " + new Date())})));
    }

    public String waitUntilRunningAndGetPublicDnsName() {
        DescribeInstancesRequest describe;
        Instance instance;
        while (!(instance = (Instance)((Reservation)this.ec2.describeInstances(describe = new DescribeInstancesRequest().withInstanceIds((Collection)Lists.newArrayList((Object[])new String[]{this.instanceId}))).getReservations().get(0)).getInstances().get(0)).getState().getName().equals("running")) {
            logger.info("Instance {} is still {}. Waiting...", (Object)this.instanceId, (Object)instance.getState().getName());
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return instance.getPublicDnsName();
    }

    protected void waitForAmiBoot() {
        try {
            logger.info("Waiting {} for the image to finish booting", (Object)this.amiBootSeconds);
            Thread.sleep(this.amiBootSeconds * 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

