/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xebialabs.impact.api.CrawlerConfig;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CrawlerCredentialsDTO
implements Serializable {
    public static final String FILTER = "filter";
    private URL endpoint;
    private URL baseUiUrl;
    private String networkId = "";
    private List<CredentialsWrapper> credentials = new ArrayList<CredentialsWrapper>();
    private double throttleFactor = 1.0;
    private CrawlerConfig crawlerConfig;
    private Map<String, CrawlerFilters> filters = new HashMap<String, CrawlerFilters>();

    public double getThrottleFactor() {
        return this.throttleFactor;
    }

    public CrawlerCredentialsDTO setThrottleFactor(double throttleFactor) {
        this.throttleFactor = throttleFactor;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint != null ? this.endpoint.toString() : null;
    }

    @JsonIgnore
    public URL getEndpointAsUrl() {
        return this.endpoint;
    }

    public CrawlerCredentialsDTO setEndpoint(URL endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @JsonIgnore
    public CrawlerCredentialsDTO setEndpointFromString(String endpoint) {
        try {
            this.endpoint = endpoint == null ? null : new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public String getBaseUiUrl() {
        return this.baseUiUrl != null ? this.baseUiUrl.toString() : null;
    }

    public CrawlerCredentialsDTO setBaseUiUrl(URL baseUiUrl) {
        this.baseUiUrl = baseUiUrl;
        return this;
    }

    @JsonIgnore
    public CrawlerCredentialsDTO setBaseUiUrlFromString(String baseUiUrl) {
        try {
            this.baseUiUrl = baseUiUrl == null ? null : new URL(baseUiUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public List<CredentialsWrapper> getCredentials() {
        return this.credentials;
    }

    public CrawlerCredentialsDTO addCredential(CredentialsWrapper credential) {
        this.credentials.add(credential);
        return this;
    }

    public CrawlerCredentialsDTO setCredentials(List<CredentialsWrapper> credentials) {
        this.credentials = credentials;
        return this;
    }

    public CrawlerConfig getCrawlerConfig() {
        return this.crawlerConfig;
    }

    public CrawlerCredentialsDTO setCrawlerConfig(CrawlerConfig crawlerConfig) {
        this.crawlerConfig = crawlerConfig;
        return this;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public CrawlerCredentialsDTO setNetworkId(String networkId) {
        this.networkId = networkId;
        return this;
    }

    @JsonIgnore
    public CrawlerCredentialsDTO setEndpointAsUrl(URL endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public CrawlerCredentialsDTO addFilter(String key, List<String> values) {
        this.filters.put(key, new CrawlerFilters().setFilter(values));
        return this;
    }

    public List<String> getFilterValues(String filterKey) {
        return Optional.ofNullable(this.filters.get(filterKey)).flatMap(v -> Optional.ofNullable(((CrawlerFilters)v).filter)).orElse(Collections.emptyList());
    }

    public Map<String, CrawlerFilters> getFilters() {
        return this.filters;
    }

    public CrawlerCredentialsDTO setFilters(Map<String, Object> filters) {
        this.filters = new HashMap<String, CrawlerFilters>();
        filters.forEach((filterName, filter) -> {
            if (filter instanceof List) {
                this.filters.put((String)filterName, new CrawlerFilters().setFilter((List)filter));
            } else if (filter instanceof Map && ((Map)filter).containsKey(FILTER) && ((Map)filter).get(FILTER) instanceof List) {
                this.filters.put((String)filterName, new CrawlerFilters().setFilter((List)((Map)filter).get(FILTER)));
            } else if (filter instanceof CrawlerFilters) {
                this.filters.put((String)filterName, (CrawlerFilters)filter);
            }
        });
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrawlerCredentialsDTO that = (CrawlerCredentialsDTO)o;
        return Double.compare(that.throttleFactor, this.throttleFactor) == 0 && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.baseUiUrl, that.baseUiUrl) && Objects.equals(this.networkId, that.networkId) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.crawlerConfig, that.crawlerConfig) && Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.baseUiUrl, this.networkId, this.credentials, this.throttleFactor, this.crawlerConfig, this.filters);
    }

    public String toString() {
        return "CrawlerCredentialsDTO{endpoint=" + this.endpoint + ", baseUiUrl=" + this.baseUiUrl + ", networkId='" + this.networkId + '\'' + ", credentials=" + this.credentials + ", throttleFactor=" + this.throttleFactor + ", crawlerConfig=" + this.crawlerConfig + ", filters=" + this.filters + '}';
    }

    public static class CrawlerFilters
    implements Serializable {
        private List<String> filter;

        public List<String> getFilter() {
            return this.filter;
        }

        public CrawlerFilters setFilter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CrawlerFilters that = (CrawlerFilters)o;
            return Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return Objects.hash(this.filter);
        }

        public String toString() {
            return "CrawlerFilters{filter=" + this.filter + '}';
        }
    }

    public static class CredentialsWrapper
    implements Serializable {
        private String username;
        private String password;

        public String getUsername() {
            return this.username;
        }

        public CredentialsWrapper setUsername(String username) {
            this.username = username;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public CredentialsWrapper setPassword(String password) {
            this.password = password;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CredentialsWrapper that = (CredentialsWrapper)o;
            return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.password);
        }

        public String toString() {
            return "CredentialsWrapper{username='" + this.username + '\'' + ", password='" + this.password + '\'' + '}';
        }
    }
}

