/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.commons.html;

import com.xebialabs.commons.html.Element;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class HtmlWriter {
    private final PrintWriter writer;

    public HtmlWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void write(String text) {
        this.writer.print(text);
    }

    public Element element(String name, Object ... items) {
        return new Element(name, items).setWriter(this.writer);
    }

    public Element html(Object ... content) {
        return this.element("html", content);
    }

    public Element head(Object ... content) {
        return this.element("head", content);
    }

    public Element title(String title) {
        return this.element("title", title);
    }

    public Element linkCss(String uri) {
        return this.element("link", new Object[0]).attribute("rel", "stylesheet").attribute("type", "text/css").attribute("href", uri);
    }

    public Element body(Object ... content) {
        return this.element("body", content);
    }

    public Element div(Object ... content) {
        return this.element("div", content);
    }

    public Element span(Object ... content) {
        return this.element("span", content);
    }

    public Element h1(Object ... content) {
        return this.element("h1", content);
    }

    public Element h2(Object ... content) {
        return this.element("h2", content);
    }

    public Element h3(Object ... content) {
        return this.element("h3", content);
    }

    public Element table(Object ... content) {
        return this.element("table", content);
    }

    public Element tr(Object ... content) {
        return this.element("tr", content);
    }

    public Element th(Object ... content) {
        return this.element("th", content);
    }

    public Element row(Object ... content) {
        return this.element("tr", this.wrap("td", content).toArray());
    }

    public Element rowHeader(Object ... content) {
        return this.element("tr", this.wrap("th", content).toArray());
    }

    public List<Element> wrap(String name, Object[] content) {
        ArrayList<Element> cells = new ArrayList<Element>();
        if (content != null) {
            for (Object item : content) {
                cells.add(this.element(name, item));
            }
        }
        return cells;
    }

    public Element td(Object ... content) {
        return this.element("td", content);
    }

    public Element p(Object ... content) {
        return this.element("p", content);
    }

    public Element link(String target, Object ... content) {
        return this.element("a", content).attribute("href", target);
    }

    public Element anchor(String target, Object ... content) {
        return this.element("a", content).attribute("id", target).add("");
    }

    public Element hr() {
        return this.element("hr", new Object[0]);
    }

    public Element img(String src, Object ... content) {
        return this.element("img", content).attribute("src", src);
    }

    public Element h4(Object ... content) {
        return this.element("h4", content);
    }

    public Element bold(Object ... content) {
        return this.element("b", content);
    }

    public Element italic(Object ... content) {
        return this.element("i", content);
    }

    public Element code(Object ... content) {
        return this.element("code", content);
    }

    public Element br() {
        return this.element("br", new Object[0]);
    }

    public Element definitionList(Object term, Object ... content) {
        Element dl = this.element("dl", this.element("dt", term));
        if (content != null) {
            for (Object item : content) {
                dl.add(this.element("dd", item));
            }
        }
        return dl;
    }
}

