/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.commons.html;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Element {
    private final String name;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private List<Object> content = new ArrayList<Object>();
    private PrintWriter myWriter;

    public Element(String name, Object ... items) {
        this.name = name;
        this.add(items);
    }

    public Element setWriter(PrintWriter writer) {
        this.myWriter = writer;
        return this;
    }

    public Element add(Object ... items) {
        if (items == null) {
            return this;
        }
        this.content.addAll(Arrays.asList(items));
        return this;
    }

    public Element attribute(String attribute, String value) {
        this.attributes.put(attribute, value);
        return this;
    }

    public String open() {
        return this.open(false);
    }

    public String open(boolean close) {
        StringBuilder builder = new StringBuilder("<").append(this.name);
        for (String key : this.attributes.keySet()) {
            builder.append(" ").append(key).append("=\"").append(this.attributes.get(key)).append("\"");
        }
        if (close) {
            builder.append("/");
        }
        builder.append(">");
        return builder.toString();
    }

    public String close() {
        return "</" + this.name + ">";
    }

    public String toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.write(new PrintWriter(writer));
        return ((Object)writer).toString();
    }

    public void write() {
        this.write(this.myWriter);
    }

    public void write(PrintWriter writer) {
        if (this.content.isEmpty()) {
            writer.println(this.open(true));
        } else {
            boolean newline = this.content.size() > 1 || this.content.size() == 1 && this.content.get(0) instanceof Element;
            this.writeOpen(writer, newline);
            this.writeContent(writer);
            this.writeClose(writer);
        }
    }

    public void writeOpen() {
        this.writeOpen(this.myWriter, true);
    }

    public void writeOpen(PrintWriter writer, boolean newline) {
        writer.print(this.open());
        if (newline) {
            writer.println();
        }
    }

    public void writeContent() {
        this.writeContent(this.myWriter);
    }

    public void writeContent(PrintWriter writer) {
        for (Object item : this.content) {
            if (item instanceof Element) {
                ((Element)item).write(writer);
                continue;
            }
            writer.print(item);
        }
    }

    public void writeClose() {
        this.writeClose(this.myWriter);
    }

    public void writeClose(PrintWriter writer) {
        writer.println(this.close());
    }

    public Element id(String id) {
        return this.attribute("id", id);
    }

    public Element cssClass(String className) {
        return this.attribute("class", className);
    }
}

