package com.xebialabs.gradle.plugins.xlrelease.tasks;

import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

/**
 * Gradle task which stops a running XL Release instance.
 */
class StopXlReleaseTask extends DefaultTask {

  @Input
  def xlReleasePort

  StopXlReleaseTask() {
    this.setGroup("xlr");
    this.setDescription("Gradle task that stops a running XL Release instance.");
  }

  @TaskAction
  void stopXLRelease() {
    stopXLRelease(logger, "$xlReleasePort")
  }

  static void stopXLRelease(Logger logger, String xlrPort) {
    String url = "http://localhost:" + xlrPort;
    logger.lifecycle("Stopping XL Release server at " + url);
    try {
      HttpURLConnection connection = (HttpURLConnection) URI.create(url + "/server/shutdown").toURL().openConnection();
      connection.setRequestMethod("POST");
      connection.setRequestProperty("Authorization", "Basic YWRtaW46YWRtaW4=");
      connection.setRequestProperty("Cookie", "XSRF-TOKEN=1;");
      connection.setRequestProperty("X-XSRF-TOKEN", "1");
      connection.setDoOutput(true);
      connection.connect();
      connection.getResponseCode();
    } catch (IOException ex) {
      logger.info(ex.getMessage());
    }
    waitForUrl(url, false, logger);
  }

  static void waitForUrl(String url, boolean toBeAvailable, Logger logger) {
    int seconds = 300;
    while (seconds > 0) {
      try {
        HttpURLConnection connection = (HttpURLConnection) new URL(url).openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        if (toBeAvailable) return;
      } catch (IOException ignored) {
        if (!toBeAvailable) return;
      }
      logger.info("Waiting " + seconds + " seconds for " + url + " to become " + (toBeAvailable ? "available" : "unavailable"));
      try {
        Thread.sleep(2000);
      } catch (InterruptedException e) {
        Thread.currentThread().interrupt();
      }
      seconds -= 2;
    }
    throw new RuntimeException(url + " did not become " + (toBeAvailable ? "available" : "unavailable") + " in a timely manner. " +
            "You can check log file 'build/server/log/xl-release.log' for more details.");
  }
}