/*
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS
 * FOR A PARTICULAR PURPOSE. THIS CODE AND INFORMATION ARE NOT SUPPORTED BY XEBIALABS.
 */
package com.xebialabs.gradle.plugins.xlrelease

import org.gradle.api.Project

/**
 * Extension which allows to configure Gradle XL Release Plugin.
 */
class XlReleasePluginExtension {
  Project project

  /**
   * Location of unpacked XL Release server installation. May be a string or a file.
   */
  def xlReleaseHome

  /**
   * Port on which XL Release server will be started
   */
  def xlReleasePort

  /**
   * Location of XL Release license to use for testing. May be string or file.
   */
  def xlReleaseLicense

  /**
   * If true then original resources from src/main/resources will be added to XL Release classpath
   * instead of processed ones from build/. This might be handy to quickly change python scripts
   * without need to rebuild and restart the project.
   */
  boolean useSourcesDirectly = false


  File getXlReleaseHomeOrFail() {
    if (!xlReleaseHome) {
      throw new RuntimeException("Please specify location of unpacked XL Release server installation in your " +
          "gradle.properties or with '-PxlReleaseHome=/path/to/xl/release/server' command line option")
    }
    File folder = project.file(xlReleaseHome)
    if (!folder.exists() || !folder.isDirectory()) {
      throw new RuntimeException("$xlReleaseHome does not exist or is not a folder")
    }
    folder
  }

  String getXlReleasePort() {
    if (!xlReleasePort) {
      "5516"
    } else {
      xlReleasePort
    }
  }

  File getXlReleaseLicenseOrFail() {
    File license = project.file(xlReleaseLicense)
    if (!license.exists()) {
      throw new RuntimeException("Could not find license, please specify location of XL Release license file in your " +
          "gradle.properties or with '-PxlReleaseLicense=/path/to/xl-release-license.lic' command line option")
    }
    license
  }
}
