/*
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS
 * FOR A PARTICULAR PURPOSE. THIS CODE AND INFORMATION ARE NOT SUPPORTED BY XEBIALABS.
 */
package com.xebialabs.gradle.plugins.xlrelease.tasks

import groovyx.net.http.RESTClient
import org.gradle.api.DefaultTask
import org.gradle.api.logging.Logger
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.TaskAction

/**
 * Gradle task which stop a running XL Release instance.
 */
class StopXlReleaseTask extends DefaultTask {

  StopXlReleaseTask() {
    this.group = "xlr"
    this.description = "Gradle task that stops a running XL Release instance."
  }

  @TaskAction
  @SuppressWarnings("GroovyUnusedDeclaration")
  public void stopXLRelease() {
    stopXLRelease(logger, "5516")
  }

  static def stopXLRelease(Logger logger, String xlrPort) {
    def url = 'http://localhost:' + xlrPort
    logger.lifecycle("Stopping XL Release server at ${url}")
    def http = new RESTClient(url)
    try {
      http.post(path: "/server/shutdown", headers: ['Authorization': 'Basic YWRtaW46YWRtaW4='])
    } catch (ex) {
      logger.info(ex.message)
    }
    waitForUrl(url, false, logger)
  }

  static def waitForUrl(String url, boolean toBeAvailable, Logger logger) {
    def http = new RESTClient(url)
    http.handler.'success' = {}
    http.handler.'failure' = {}

    def seconds = 300
    while (seconds > 0) {
      try {
        http.get([:])
        if (toBeAvailable) return
      } catch (ConnectException ignored) {
        if (!toBeAvailable) return
      }
      logger.info("Waiting $seconds seconds for $url to become ${toBeAvailable ? "available" : "unavailable"}")
      Thread.sleep(2000)
      seconds -= 2
    }

    throw new RuntimeException("$url did not become ${toBeAvailable ? "available" : "unavailable"} in timely manner. " +
        "You can check log file 'build/server/log/xl-release.log' for more details.")
  }

}
