/*
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS
 * FOR A PARTICULAR PURPOSE. THIS CODE AND INFORMATION ARE NOT SUPPORTED BY XEBIALABS.
 */
package com.xebialabs.gradle.plugins.xlrelease

import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 * Gradle plugin which provides dependencies on libraries of an XL Release distribution.
 */
class XlReleaseDependenciesPlugin implements Plugin<Project> {

  public static final String XL_RELEASE_JARS_CONFIGURATION = 'xlReleaseJars'

  @Override
  void apply(final Project project) {
    project.plugins.apply(XlReleaseInstancePlugin)

    configureConfigurations(project)
  }

  private static def configureConfigurations(Project project) {
    project.configurations.create(XL_RELEASE_JARS_CONFIGURATION)
    project.dependencies.add(XL_RELEASE_JARS_CONFIGURATION, project.fileTree(dir: { ->
      def xlrHome = project.extensions.findByType(XlReleasePluginExtension).getXlReleaseHomeOrFail()
      project.logger.lifecycle("Using XL Release libraries from $xlrHome")
      "$xlrHome/lib"
    }))
  }
}
