/*
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS
 * FOR A PARTICULAR PURPOSE. THIS CODE AND INFORMATION ARE NOT SUPPORTED BY XEBIALABS.
 */
package com.xebialabs.gradle.plugins.xlrelease

import com.xebialabs.gradle.plugins.xlrelease.tasks.StartXlReleaseTask
import com.xebialabs.gradle.plugins.xlrelease.tasks.StopXlReleaseTask
import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 * Gradle plugin which provides tasks to start an XL Release instance with your plugin included.
 */
class XlReleaseInstancePlugin implements Plugin<Project> {

  public static final String START_TASK_NAME = 'startXLRelease'
  public static final String STOP_TASK_NAME = 'stopXLRelease'
  public static final String ADDITIONAL_CLASSPATH_CONFIGURATION = 'xlReleaseAdditionalClasspath'

  public static final String XL_RELEASE_PLUGIN_EXTENSION = "xlReleasePlugin"

  @Override
  void apply(final Project project) {
    configureExtensions(project)
    configureConfigurations(project)
    configureTasks(project)
  }

  private static def configureExtensions(Project p) {
    p.extensions.create(XL_RELEASE_PLUGIN_EXTENSION, XlReleasePluginExtension).with {
      project = p

      xlReleaseHome = project.hasProperty('xlReleaseHome') ? project.property('xlReleaseHome') : null

      xlReleaseLicense = { ->
        if (project.hasProperty('xlReleaseLicense')) {
          project.property('xlReleaseLicense')
        } else {
          "$xlReleaseHome/conf/xl-release-license.lic"
        }
      }
    }
  }

  private static def configureConfigurations(Project project) {
    project.configurations.create(ADDITIONAL_CLASSPATH_CONFIGURATION)
  }

  def static configureTasks(final Project project) {
    project.tasks.create(START_TASK_NAME, StartXlReleaseTask).configure {
      group = "other"
      description = "Starts XL Release server with current plugin included."
      dependsOn(['classes'])
      xlReleaseHome = { -> project.extensions.findByType(XlReleasePluginExtension).getXlReleaseHomeOrFail() }
      xlReleaseLicense = { -> project.extensions.findByType(XlReleasePluginExtension).getXlReleaseLicenseOrFail() }
      useSourcesDirectly = { -> project.extensions.findByType(XlReleasePluginExtension).useSourcesDirectly }
    }

    project.tasks.create(STOP_TASK_NAME, StopXlReleaseTask).configure {
      group = "other"
      description = "Stops XL Release server if it is running."
    }
  }
}
