/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.pages;

import com.xebialabs.pages.AbstractPageObject;
import com.xebialabs.pages.SharedConfigurationPage;
import com.xebialabs.specs.BaseTest;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testng.Assert;

public class SharedConfigurationPropertiesPage
extends AbstractPageObject {
    static WebDriverWait wait = new WebDriverWait((WebDriver)BaseTest.driver, 15L);

    public SharedConfigurationPropertiesPage() {
        super((WebDriver)BaseTest.driver);
    }

    @Override
    protected By getUniqueElement() {
        return By.xpath((String)"//div[@id='configuration-instance']");
    }

    public static SharedConfigurationPropertiesPage checkSharedConfigurationHeader(String header) {
        BaseTest.driver.findElement(By.xpath((String)("//h4[contains(text(),'" + header + "')]"))).isDisplayed();
        return new SharedConfigurationPropertiesPage();
    }

    public static void setEditFieldBySequence(Integer index, String text) {
        ((WebElement)BaseTest.driver.findElementsByTagName("input").get(index - 1)).sendKeys(new CharSequence[]{text});
    }

    public static void setOptionFromSelectFieldBySequence(Integer index, String text) {
        new Select((WebElement)BaseTest.driver.findElementsByTagName("select").get(index - 1)).selectByVisibleText(text);
    }

    public static void clickElementById(String id) {
        BaseTest.driver.findElementById(id).click();
    }

    public static void typeElementById(String id, String text) {
        BaseTest.driver.findElementById(id).sendKeys(new CharSequence[]{text});
    }

    public static void clickButtonByText(String btnText) {
        BaseTest.driver.findElement(By.xpath((String)("//button[contains(text(), '" + btnText + "')]"))).click();
        if (btnText.contains("Save")) {
            BaseTest.driver.findElement(By.xpath((String)"//button[@class='toast-close-button']")).click();
            wait.until((Function)ExpectedConditions.invisibilityOfElementLocated((By)By.xpath((String)"//div[@class='toast-message']")));
        }
    }

    public static void checkConnectionStatusShouldContain(String connText) {
        Assert.assertTrue((boolean)((WebElement)BaseTest.driver.findElements(By.xpath((String)"//div[@class='sub-help']//div[@class='ng-scope']//p")).get(0)).getText().contains(connText), (String)"Text not found!");
    }

    public static SharedConfigurationPage isNewConfigurationSaved() {
        return new SharedConfigurationPage();
    }
}

