/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.pages;

import com.xebialabs.pages.AbstractPageObject;
import com.xebialabs.pages.CreateReleasePage;
import com.xebialabs.pages.TaskDetailPage;
import com.xebialabs.specs.BaseTest;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ReleasePage
extends AbstractPageObject {
    static String releaseName = "";
    WebDriverWait wait = new WebDriverWait((WebDriver)BaseTest.driver, 5L);

    public ReleasePage(String releaseName) {
        super((WebDriver)BaseTest.driver);
        ReleasePage.releaseName = releaseName;
    }

    @Override
    protected By getUniqueElement() {
        return By.xpath((String)"//div[@class='btn-group btn-group-padding']");
    }

    public static TaskDetailPage addTask(String taskName, String taskType, String taskSubType) {
        BaseTest.driver.findElement(By.xpath((String)"//a[@class='add-task link']")).click();
        BaseTest.driver.findElement(By.xpath((String)"//form[@name='quickTaskForm']//input[@type='text']")).sendKeys(new CharSequence[]{taskName});
        ReleasePage.chooseTask(taskType, taskSubType);
        BaseTest.driver.findElement(By.xpath((String)"//a[@class='button add primary']")).click();
        BaseTest.driver.findElement(By.xpath((String)"//div[@ng-controller='taskDetailsController']")).click();
        return new TaskDetailPage(releaseName);
    }

    public static void chooseTask(String taskType, String taskSubType) {
        BaseTest.driver.findElementByCssSelector(".btn.btn-flat.xlr-ctx-menu-toggle.dropdown-toggle").click();
        BaseTest.driver.findElementByXPath("//a[@title='" + taskType + "']").click();
        BaseTest.driver.findElementByXPath("//ul[contains(@class, 'active')]//a[@title='" + taskSubType + "']").click();
    }

    public static ReleasePage startRelease() {
        BaseTest.driver.findElement(By.xpath((String)"//a[@class='start-release primary button ng-scope']")).click();
        BaseTest.driver.findElement(By.xpath((String)"//button[@type='button'][contains(text(),'Start')]")).click();
        return new ReleasePage(releaseName);
    }

    public static ReleasePage waitTillReleaseCompletes(Integer timeout) {
        WebDriverWait waitNew = new WebDriverWait((WebDriver)BaseTest.driver, (long)timeout.intValue());
        waitNew.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"//span[@class='label label-completed']")));
        return new ReleasePage(releaseName);
    }

    public static ReleasePage waitTillReleaseFails(Integer timeout) {
        WebDriverWait waitNew = new WebDriverWait((WebDriver)BaseTest.driver, (long)timeout.intValue());
        waitNew.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"//span[@class='label label-warning-failed']")));
        return new ReleasePage(releaseName);
    }

    public static CreateReleasePage newReleaseFromTemplate() {
        BaseTest.driver.findElement(By.xpath((String)"//a[@class='new-release button primary ng-scope']")).click();
        return new CreateReleasePage();
    }
}

