/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.specs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class BaseTest {
    protected static final String WEB_SERVER = System.getProperty("WEB_SERVER", "http://localhost:5516");
    protected static final String BROWSER = System.getProperty("BROWSER", "chrome");
    protected static final boolean REMOTE_DRIVER = Boolean.valueOf(System.getProperty("REMOTE_DRIVER", "false"));
    protected static final String SELENIUM_HOST = System.getProperty("SELENIUM_HOST", "localhost");
    protected static final int SELENIUM_PORT = Integer.valueOf(System.getProperty("SELENIUM_PORT", "4444"));
    public static RemoteWebDriver driver;

    @BeforeClass
    public void setupWebDriver() throws MalformedURLException {
        System.out.println("called before class");
        if (REMOTE_DRIVER) {
            this.setupRemoteDriver();
            driver.setFileDetector((FileDetector)new LocalFileDetector());
        } else {
            this.setupLocalDriver();
        }
        driver.manage().timeouts().implicitlyWait(20L, TimeUnit.SECONDS);
        driver.manage().window().maximize();
    }

    private void setupLocalDriver() {
        if (BROWSER.equals("firefox")) {
            System.setProperty("webdriver.gecko.driver", this.copyDriver("geckodriver-mac"));
            driver = new FirefoxDriver();
            driver.get(WEB_SERVER);
        } else if (BROWSER.equals("chrome")) {
            System.setProperty("webdriver.chrome.driver", this.copyDriver("chromedriver-mac"));
            driver = new ChromeDriver();
            driver.get(WEB_SERVER);
        } else {
            throw new RuntimeException("Browser type unsupported");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String copyDriver(String driverName) {
        String tempDir = System.getProperty("java.io.tmpdir");
        try (InputStream stream = this.getClass().getResourceAsStream("/drivers/" + driverName);){
            Path resolve = Paths.get(tempDir, new String[0]).resolve(driverName);
            Files.copy(stream, resolve, new CopyOption[0]);
            File file = resolve.toFile();
            file.setExecutable(true);
            file.deleteOnExit();
            String string = resolve.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setupRemoteDriver() throws MalformedURLException {
        DesiredCapabilities capabilities;
        if (BROWSER.equals("firefox")) {
            capabilities = DesiredCapabilities.firefox();
        } else if (BROWSER.equals("internetExplorer")) {
            capabilities = DesiredCapabilities.internetExplorer();
            capabilities.setCapability("ignoreProtectedModeSettings", true);
        } else if (BROWSER.equals("chrome")) {
            capabilities = DesiredCapabilities.chrome();
        } else {
            throw new RuntimeException("Browser type unsupported");
        }
        driver = new RemoteWebDriver(new URL("http://" + SELENIUM_HOST + ":" + SELENIUM_PORT + "/wd/hub"), (Capabilities)capabilities);
        driver.get(WEB_SERVER);
    }

    @AfterClass
    public void suiteTearDown() {
        System.out.println("called after class");
        driver.manage().deleteAllCookies();
        driver.quit();
    }
}

