/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.gradle.plugins.license.maven;

import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.Header;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import nl.javadude.gradle.plugins.license.maven.CallbackWithFailure;
import nl.javadude.gradle.plugins.license.maven.DocumentFactory;
import nl.javadude.gradle.plugins.license.maven.LicenseCheckMojo;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public final class LicenseFormatMojo
implements CallbackWithFailure {
    Logger logger = Logging.getLogger(LicenseCheckMojo.class);
    File basedir;
    protected boolean dryRun = false;
    protected boolean skipExistingHeaders = false;
    public final Collection<File> missingHeaders = new ConcurrentLinkedQueue<File>();

    public LicenseFormatMojo(File basedir, boolean dryRun, boolean skipExistingHeaders) {
        this.basedir = basedir;
        this.dryRun = dryRun;
        this.skipExistingHeaders = skipExistingHeaders;
    }

    public void onHeaderNotFound(Document document, Header header) {
        document.parseHeader();
        if (document.headerDetected()) {
            if (this.skipExistingHeaders) {
                this.logger.info("Keeping license header in: {}", (Object)DocumentFactory.getRelativeFile(this.basedir, document));
                return;
            }
            document.removeHeader();
        }
        this.logger.lifecycle("Updating license header in: {}", new Object[]{DocumentFactory.getRelativeFile(this.basedir, document)});
        document.updateHeader(header);
        this.missingHeaders.add(document.getFile());
        if (!this.dryRun) {
            document.save();
        } else {
            String name = document.getFile().getName() + ".licensed";
            File copy = new File(document.getFile().getParentFile(), name);
            this.logger.debug("Result saved to: {}", (Object)copy);
            document.saveTo(copy);
        }
    }

    public void onUnknownFile(Document document, Header header) {
        this.logger.error("Unknown file: {}", (Object)DocumentFactory.getRelativeFile(this.basedir, document));
    }

    public void onExistingHeader(Document document, Header header) {
        this.logger.info("Header OK in: {}", (Object)DocumentFactory.getRelativeFile(this.basedir, document));
    }

    @Override
    public boolean hadFailure() {
        return false;
    }

    @Override
    public Collection<File> getAffected() {
        return this.missingHeaders;
    }
}

