/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.gradle.plugins.license.maven;

import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.Header;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import nl.javadude.gradle.plugins.license.maven.CallbackWithFailure;
import nl.javadude.gradle.plugins.license.maven.DocumentFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public final class LicenseCheckMojo
implements CallbackWithFailure {
    Logger logger = Logging.getLogger(LicenseCheckMojo.class);
    private final File basedir;
    public final Collection<File> missingHeaders = new ConcurrentLinkedQueue<File>();
    protected boolean skipExistingHeaders = false;

    public LicenseCheckMojo(File basedir, boolean skipExistingHeaders) {
        this.basedir = basedir;
        this.skipExistingHeaders = skipExistingHeaders;
    }

    public void onHeaderNotFound(Document document, Header header) {
        document.parseHeader();
        if (document.headerDetected() && this.skipExistingHeaders) {
            this.logger.info("Ignoring header in: {}", (Object)DocumentFactory.getRelativeFile(this.basedir, document));
            return;
        }
        this.logger.lifecycle("Missing header in: {}", new Object[]{DocumentFactory.getRelativeFile(this.basedir, document)});
        this.missingHeaders.add(document.getFile());
    }

    public void onUnknownFile(Document document, Header header) {
        this.logger.error("Unknown file: {}", (Object)DocumentFactory.getRelativeFile(this.basedir, document));
    }

    public void onExistingHeader(Document document, Header header) {
        this.logger.info("Header OK in: {}", (Object)DocumentFactory.getRelativeFile(this.basedir, document));
    }

    @Override
    public boolean hadFailure() {
        return !this.missingHeaders.isEmpty();
    }

    @Override
    public Collection<File> getAffected() {
        return this.missingHeaders;
    }
}

