/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.gradle.plugins.license.maven;

import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.document.DocumentPropertiesLoader;
import com.mycila.maven.plugin.license.header.HeaderDefinition;
import java.io.File;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;

public final class DocumentFactory {
    private final Map<String, String> mapping;
    private final Map<String, HeaderDefinition> definitions;
    private final File basedir;
    private final String encoding;
    private final String[] keywords;
    private final DocumentPropertiesLoader documentPropertiesLoader;

    public DocumentFactory(File basedir, Map<String, String> mapping, Map<String, HeaderDefinition> definitions, String encoding, String[] keywords, DocumentPropertiesLoader documentPropertiesLoader) {
        this.mapping = mapping;
        this.definitions = definitions;
        this.basedir = basedir;
        this.encoding = encoding;
        this.keywords = (String[])keywords.clone();
        this.documentPropertiesLoader = documentPropertiesLoader;
    }

    public Document createDocuments(String file) {
        return this.getWrapper(file, this.encoding);
    }

    public Document createDocuments(File file) {
        return this.getWrapper(file, this.encoding);
    }

    private Document getWrapper(String file, String encoding) {
        return this.getWrapper(new File(this.basedir, file), encoding);
    }

    private Document getWrapper(File file, String encoding) {
        String headerType = this.mapping.get(FileUtils.extension((String)file.getName()).toLowerCase());
        headerType = headerType == null ? this.mapping.get("") : headerType.toLowerCase();
        return new Document(file, this.definitions.get(headerType), encoding, this.keywords, this.documentPropertiesLoader);
    }

    public static String getRelativeFile(File basedir, Document document) {
        String prefix = basedir.getAbsolutePath();
        String whole = document.getFile().getAbsolutePath();
        if (whole.startsWith(prefix)) {
            return whole.substring(prefix.length() + 1);
        }
        return document.getFile().getPath();
    }
}

