/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.gradle.plugins.license.maven;

import com.mycila.maven.plugin.license.Callback;
import com.mycila.maven.plugin.license.HeaderSection;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.document.DocumentPropertiesLoader;
import com.mycila.maven.plugin.license.document.DocumentType;
import com.mycila.maven.plugin.license.header.Header;
import com.mycila.maven.plugin.license.header.HeaderDefinition;
import com.mycila.maven.plugin.license.header.HeaderSource;
import com.mycila.maven.plugin.license.header.HeaderType;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import nl.javadude.gradle.plugins.license.maven.DocumentFactory;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class AbstractLicenseMojo {
    static Logger logger = Logging.getLogger(AbstractLicenseMojo.class);
    Collection<File> validHeaders;
    File rootDir;
    Map<String, String> initial;
    protected String[] keywords = new String[]{"copyright"};
    protected List<HeaderDefinition> headerDefinitions;
    protected HeaderSection[] headerSections = new HeaderSection[0];
    protected String encoding;
    protected float concurrencyFactor = 1.5f;
    protected Map<String, String> mapping;
    boolean dryRun;
    boolean skipExistingHeaders;
    boolean useDefaultMappings;
    boolean strictCheck;
    URI header;
    FileCollection source;

    public AbstractLicenseMojo(Collection<File> validHeaders, File rootDir, Map<String, String> initial, boolean dryRun, boolean skipExistingHeaders, boolean useDefaultMappings, boolean strictCheck, URI header, FileCollection source, Map<String, String> mapping, String encoding, List<HeaderDefinition> headerDefinitions) {
        this.validHeaders = validHeaders;
        this.rootDir = rootDir;
        this.initial = initial;
        this.dryRun = dryRun;
        this.skipExistingHeaders = skipExistingHeaders;
        this.useDefaultMappings = useDefaultMappings;
        this.strictCheck = strictCheck;
        this.header = header;
        this.source = source;
        this.mapping = mapping;
        this.encoding = encoding;
        this.headerDefinitions = headerDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void execute(final Callback callback) throws MalformedURLException, IOException {
        final Map<String, String> props = this.mergeProperties();
        final Header h = new Header((HeaderSource)new HeaderSource.UrlHeaderSource(this.header.toURL(), this.encoding), this.headerSections);
        logger.debug("Header {}:\n{}", (Object)h.getLocation(), (Object)h);
        if (this.validHeaders == null) {
            this.validHeaders = new ArrayList<File>();
        }
        final ArrayList<Header> validHeaders = new ArrayList<Header>(this.validHeaders.size());
        for (File validHeader : this.validHeaders) {
            validHeaders.add(new Header((HeaderSource)new HeaderSource.UrlHeaderSource(validHeader.toURI().toURL(), this.encoding), this.headerSections));
        }
        DocumentPropertiesLoader documentPropertiesLoader = new DocumentPropertiesLoader(){

            public Properties load(Document d) {
                Properties properties = new Properties();
                for (String key : props.keySet()) {
                    properties.put(key, String.valueOf(props.get(key)));
                }
                properties.put("file.name", d.getFile().getName());
                return properties;
            }
        };
        Map<String, HeaderDefinition> definitions = this.buildHeaderDefinitions();
        final DocumentFactory documentFactory = new DocumentFactory(this.rootDir, this.buildMapping(definitions), definitions, this.encoding, this.keywords, documentPropertiesLoader);
        int nThreads = (int)((float)Runtime.getRuntime().availableProcessors() * this.concurrencyFactor);
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
        int count = 0;
        logger.debug("Number of execution threads: {}", (Object)nThreads);
        try {
            for (final File file : this.source) {
                completionService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Document document = documentFactory.createDocuments(file);
                        logger.debug("Selected file: {} [header style: {}]", (Object)DocumentFactory.getRelativeFile(AbstractLicenseMojo.this.rootDir, document), (Object)document.getHeaderDefinition());
                        if (document.isNotSupported()) {
                            logger.warn("Unknown file extension: {}", (Object)DocumentFactory.getRelativeFile(AbstractLicenseMojo.this.rootDir, document));
                        } else if (document.is(h)) {
                            logger.debug("Skipping header file: {}", (Object)DocumentFactory.getRelativeFile(AbstractLicenseMojo.this.rootDir, document));
                        } else if (document.hasHeader(h, AbstractLicenseMojo.this.strictCheck)) {
                            callback.onExistingHeader(document, h);
                        } else {
                            boolean headerFound = false;
                            for (Header validHeader : validHeaders) {
                                headerFound = document.hasHeader(validHeader, AbstractLicenseMojo.this.strictCheck);
                                if (!headerFound) continue;
                                callback.onExistingHeader(document, h);
                                break;
                            }
                            if (!headerFound) {
                                callback.onHeaderNotFound(document, h);
                            }
                        }
                    }
                }, null);
                ++count;
            }
            while (count-- > 0) {
                try {
                    completionService.take().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    if (!(cause instanceof RuntimeException)) throw new GradleException(cause.getMessage(), cause);
                    throw (RuntimeException)cause;
                    return;
                }
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    protected final Map<String, String> mergeProperties() {
        HashMap<String, String> props = new HashMap<String, String>(System.getenv());
        props.putAll(this.initial);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return props;
    }

    private Map<String, String> buildMapping(Map<String, HeaderDefinition> headerDefinitions) {
        HashMap<String, String> extensionMapping = this.useDefaultMappings ? new HashMap<String, String>(DocumentType.defaultMapping()) : new HashMap();
        List<HeaderType> headerTypes = Arrays.asList(HeaderType.values());
        HashSet<String> validHeaderTypes = new HashSet<String>();
        for (HeaderType headerType : headerTypes) {
            validHeaderTypes.add(headerType.name().toLowerCase());
        }
        validHeaderTypes.addAll(headerDefinitions.keySet());
        for (Map.Entry entry : this.mapping.entrySet()) {
            String headerType = ((String)entry.getValue()).toLowerCase();
            String fileType = ((String)entry.getKey()).toLowerCase();
            if (!validHeaderTypes.contains(headerType)) {
                throw new InvalidUserDataException(String.format("The provided header type (%s) for %s is invalid", headerType, fileType));
            }
            extensionMapping.put(fileType, headerType);
        }
        extensionMapping.put(DocumentType.UNKNOWN.getExtension(), DocumentType.UNKNOWN.getDefaultHeaderTypeName());
        return extensionMapping;
    }

    private Map<String, HeaderDefinition> buildHeaderDefinitions() {
        HashMap<String, HeaderDefinition> headers = new HashMap<String, HeaderDefinition>(HeaderType.defaultDefinitions());
        for (HeaderDefinition headerDefinitionBuilder : this.headerDefinitions) {
            headers.put(headerDefinitionBuilder.getType(), headerDefinitionBuilder);
        }
        headers.put(HeaderType.UNKNOWN.getDefinition().getType(), HeaderType.UNKNOWN.getDefinition());
        return headers;
    }

    private File findResource(String resource) {
        return null;
    }
}

