/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.satellite;

import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.domain.Satellite;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0005H\u0007\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/ShutdownSatelliteTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "copyStopSatelliteScript", "", "satellite", "Lai/digital/integration/server/deploy/domain/Satellite;", "stopSatellite", "stop", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nShutdownSatelliteTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShutdownSatelliteTask.kt\nai/digital/integration/server/deploy/tasks/satellite/ShutdownSatelliteTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1869#2,2:54\n*S KotlinDebug\n*F\n+ 1 ShutdownSatelliteTask.kt\nai/digital/integration/server/deploy/tasks/satellite/ShutdownSatelliteTask\n*L\n41#1:54,2\n*E\n"})
public class ShutdownSatelliteTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "shutdownSatellite";
    @NotNull
    public static final String STOP_SATELLITE_SCRIPT = "stopSatellite.sh";

    public ShutdownSatelliteTask() {
        this.setGroup("Integration Server");
    }

    private final void copyStopSatelliteScript(Satellite satellite) {
        block0: {
            InputStream from = ((Function0)ShutdownSatelliteTask::copyStopSatelliteScript$lambda$0).getClass().getClassLoader().getResourceAsStream("satellite/bin/stopSatellite.sh");
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Path intoDir = Paths.get(SatelliteUtil.Companion.getSatelliteWorkingDir(project, satellite), new String[0]).resolve(STOP_SATELLITE_SCRIPT);
            InputStream inputStream = from;
            if (inputStream == null) break block0;
            InputStream source = inputStream;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)intoDir);
            FileUtil.Companion.copyFile(source, intoDir);
        }
    }

    private final void stopSatellite(Satellite satellite) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ProcessUtil.Companion.chMod(project, "777", ((Object)Paths.get(SatelliteUtil.Companion.getSatelliteWorkingDir(project2, satellite), new String[0]).resolve(STOP_SATELLITE_SCRIPT).toAbsolutePath()).toString());
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"stopSatellite");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        pairArray[1] = TuplesKt.to((Object)"workDir", (Object)new File(SatelliteUtil.Companion.getSatelliteWorkingDir(project3, satellite)));
        ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
        this.getProject().getLogger().lifecycle("Satellite server '" + satellite.getName() + "' successfully shutdown.");
    }

    @TaskAction
    public final void stop() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable $this$forEach$iv = SatelliteUtil.Companion.getSatellites(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Satellite satellite = (Satellite)element$iv;
            boolean bl = false;
            this.getProject().getLogger().lifecycle("Shutting down satellite " + satellite.getName());
            this.copyStopSatelliteScript(satellite);
            this.stopSatellite(satellite);
        }
    }

    private static final Unit copyStopSatelliteScript$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/ShutdownSatelliteTask$Companion;", "", "<init>", "()V", "NAME", "", "STOP_SATELLITE_SCRIPT", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

