/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.kube.scanning;

import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.KubeScanningUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\f\u001a\u00020\u0005H\u0007\u00a8\u0006\u000e"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/KubeAwsScannerTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "kubeBenchBuildAndPushImage", "", "ecrKubeBenchImage", "", "createEcrRepoAndLogin", "createECRImageTag", "pushImageToECR", "updateKubeBenchImage", "launch", "Companion", "integration-server-gradle-plugin"})
public class KubeAwsScannerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "kubeAwsScanner";
    @NotNull
    public static final String reportFile = "aws-eks";

    public KubeAwsScannerTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"checkingOutKubeBench"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"KubeAwsScannerFinalizer"};
        this.finalizedBy(objectArray);
    }

    private final void kubeBenchBuildAndPushImage(String ecrKubeBenchImage) {
        this.createEcrRepoAndLogin();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KubeScanningUtil.Companion.buildKubeBench(project);
        this.createECRImageTag(ecrKubeBenchImage);
        this.pushImageToECR(ecrKubeBenchImage);
    }

    private final void createEcrRepoAndLogin() {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String string = "aws ecr --region " + KubeScanningUtil.Companion.getRegion(project2) + " create-repository --repository-name k8s/kube-bench --image-tag-mutability MUTABLE";
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project3).getLogOutput(), false, 0L, 52, null);
        Project project4 = this.getProject();
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
        String string2 = KubeScanningUtil.Companion.getRegion(project5);
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
        String string3 = KubeScanningUtil.Companion.getRegion(project6);
        Project project7 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"getProject(...)");
        String string4 = "aws ecr --region " + string2 + " get-login-password --region " + string3 + " | docker login --username AWS --password-stdin " + KubeScanningUtil.Companion.getAWSAccountId(project7);
        Project project8 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"getProject(...)");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project4, string4, null, KubeScanningUtil.Companion.getKubeScanner(project8).getLogOutput(), false, 0L, 52, null);
    }

    private final void createECRImageTag(String ecrKubeBenchImage) {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String string = "docker tag k8s/kube-bench:" + KubeScanningUtil.Companion.getKubeScanner(project2).getKubeBenchTagVersion() + " " + ecrKubeBenchImage;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project3).getLogOutput(), false, 0L, 52, null);
    }

    private final void pushImageToECR(String ecrKubeBenchImage) {
        Project project = this.getProject();
        String string = "docker push " + ecrKubeBenchImage;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project2).getLogOutput(), false, 0L, 52, null);
    }

    private final void updateKubeBenchImage(String ecrKubeBenchImage) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        File file = new File(KubeScanningUtil.Companion.getKubeBenchDir(project), "job-eks.yaml");
        Object object = YamlFileUtil.Companion.readFileKey$default(YamlFileUtil.Companion, file, "spec.template.spec.containers[0].command", false, 4, null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
        List existingCommand = TypeIntrinsics.asMutableList((Object)object);
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"spec.template.spec.containers[0].image", (Object)ecrKubeBenchImage);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        pairArray[1] = TuplesKt.to((Object)"spec.template.spec.containers[0].command", KubeScanningUtil.Companion.getCommand(project2, existingCommand));
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 4, null);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = KubeScanningUtil.Companion.getAWSAccountId(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String ecrKubeBenchImage = string + "/k8s/kube-bench:" + KubeScanningUtil.Companion.getKubeScanner(project2).getKubeBenchTagVersion();
        this.kubeBenchBuildAndPushImage(ecrKubeBenchImage);
        this.updateKubeBenchImage(ecrKubeBenchImage);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        KubeCtlHelper kubeCtlHelper = KubeScanningUtil.Companion.getKubectlHelper(project3);
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        kubeCtlHelper.applyFile(new File(KubeScanningUtil.Companion.getKubeBenchDir(project4) + "/job-eks.yaml"));
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
        KubeScanningUtil.Companion.generateReport(project5, "aws-eks.log");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/KubeAwsScannerTask$Companion;", "", "<init>", "()V", "NAME", "", "reportFile", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

