/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.centralConfiguration;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.deploy.domain.CentralConfigurationServer;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/PrepareCentralConfigurationServerTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "launch", "", "prepare", "project", "Lorg/gradle/api/Project;", "copyCentralConfigurationDir", "server", "Lai/digital/integration/server/common/domain/Server;", "cc", "Lai/digital/integration/server/deploy/domain/CentralConfigurationServer;", "createConfFile", "Companion", "integration-server-gradle-plugin"})
public class PrepareCentralConfigurationServerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "prepareCentralConfigurationServer";

    public PrepareCentralConfigurationServerTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DeployServerUtil.Companion.isDeployServerDefined(project)) {
            Object[] objectArray = new Object[]{"serverYamlPatch"};
            this.dependsOn(objectArray);
        }
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project);
            }
        });
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.prepare(project);
    }

    public final void prepare(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CentralConfigurationServer cc = CentralConfigurationServerUtil.Companion.getCentralConfigurationServer(project);
        Server server = DeployServerUtil.Companion.getServer(project);
        project.getLogger().lifecycle("Preparing central configuration server " + cc.getVersion() + " before launching it.");
        this.createConfFile(project, cc);
        this.copyCentralConfigurationDir(project, server, cc);
    }

    private final void copyCentralConfigurationDir(Project project, Server server, CentralConfigurationServer cc) {
        project.getLogger().lifecycle("Copying centralConfiguration directory from " + server.getName() + " to central configuration server");
        String[] stringArray = new String[]{"centralConfiguration"};
        File sourceDir = Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project), stringArray).toFile();
        String[] stringArray2 = new String[]{"centralConfiguration"};
        File destinationDir = Paths.get(((Object)CentralConfigurationServerUtil.Companion.getServerPath(project, cc)).toString(), stringArray2).toFile();
        FileUtils.copyDirectory((File)sourceDir, (File)destinationDir);
    }

    private final void createConfFile(Project project, CentralConfigurationServer cc) {
        project.getLogger().lifecycle("Creating deployit.conf file for central configuration server");
        File file = project.file((Object)(CentralConfigurationServerUtil.Companion.getServerPath(project, cc) + "/conf/deployit.conf"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        File file2 = file;
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        file2.createNewFile();
        FilesKt.appendText$default((File)file2, (String)("http.port=" + cc.getHttpPort() + "\n"), null, (int)2, null);
        FilesKt.appendText$default((File)file2, (String)"xl.spring.cloud.encrypt.key=MQle?8_pwB^>f<&\n", null, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/PrepareCentralConfigurationServerTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

