/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks;

import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.InfrastructureUtil;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.DeployShutdownUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lai/digital/integration/server/deploy/tasks/ShutdownDeployIntegrationServerTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "shutdown", "", "Companion", "integration-server-gradle-plugin"})
public class ShutdownDeployIntegrationServerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "shutdownDeployIntegrationServer";

    public ShutdownDeployIntegrationServerTask() {
        this.setGroup("Integration Server");
        final ShutdownDeployIntegrationServerTask that = this;
        this.getProject().afterEvaluate(new Action(){

            public final void execute(Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                Project project = $this$afterEvaluate.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (DeployServerUtil.Companion.isClusterEnabled(project)) {
                    Object[] objectArray = new Object[]{"stopDeployCluster"};
                    v1 = that.dependsOn(objectArray);
                } else {
                    Object[] objectArray;
                    Project project2 = $this$afterEvaluate.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    if (DeployServerUtil.Companion.isDockerBased(project2)) {
                        objectArray = new Object[]{"dockerBasedStopDeploy"};
                        that.dependsOn(objectArray);
                    }
                    Project project3 = $this$afterEvaluate.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                    if (WorkerUtil.Companion.hasWorkers(project3)) {
                        objectArray = new Object[]{"shutdownWorkers"};
                        that.dependsOn(objectArray);
                    }
                    Project project4 = $this$afterEvaluate.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                    if (SatelliteUtil.Companion.hasSatellites(project4)) {
                        objectArray = new Object[]{"shutdownSatellite"};
                        that.dependsOn(objectArray);
                    }
                    Project project5 = $this$afterEvaluate.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
                    if (DbUtil.Companion.isDerby(project5)) {
                        objectArray = new Object[]{"derbyStop"};
                        v6 = that.finalizedBy(objectArray);
                    } else {
                        objectArray = new Object[]{"databaseStop"};
                        v6 = that.finalizedBy(objectArray);
                    }
                    Project project6 = $this$afterEvaluate.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
                    if (InfrastructureUtil.Companion.hasInfrastructures(project6)) {
                        objectArray = new Object[]{"infrastructureStop"};
                        that.finalizedBy(objectArray);
                    }
                    Project project7 = $this$afterEvaluate.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"getProject(...)");
                    if (CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project7)) {
                        objectArray = new Object[]{"shutdownCentralConfigurationServer"};
                        that.dependsOn(objectArray);
                    }
                    objectArray = new Object[]{"shutdownCache"};
                    v1 = that.finalizedBy(objectArray);
                }
            }
        });
    }

    @TaskAction
    public final void shutdown() {
        this.getProject().getLogger().lifecycle("About to shutting down Deploy Server.");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DeployServerUtil.Companion.isDockerBased(project)) {
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!DeployClusterUtil.Companion.isOperatorProvider(project2)) {
                Project project3 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                DeployShutdownUtil.Companion.shutdownServer(project3);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/ShutdownDeployIntegrationServerTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

