/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.domain.PekkoSecured;
import ai.digital.integration.server.common.util.TlsUtil;
import ai.digital.integration.server.deploy.domain.Satellite;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/internals/SatelliteInitializeUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class SatelliteInitializeUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/deploy/internals/SatelliteInitializeUtil$Companion;", "", "<init>", "()V", "prepare", "", "project", "Lorg/gradle/api/Project;", "satellite", "Lai/digital/integration/server/deploy/domain/Satellite;", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void prepare(@NotNull Project project, @NotNull Satellite satellite) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)satellite, (String)"satellite");
            File satelliteConf = SatelliteUtil.Companion.getSatelliteConf(project, satellite);
            ConfigRenderOptions options = ConfigRenderOptions.concise().setFormatted(true).setJson(false);
            Config newConfiguration = null;
            newConfiguration = ConfigFactory.parseString((String)FilesKt.readText((File)satelliteConf, (Charset)Charsets.UTF_8)).withValue("deploy.server.bind-hostname", ConfigValueFactory.fromAnyRef((Object)satellite.getServerPekkoBindHostName())).withValue("deploy.server.hostname", ConfigValueFactory.fromAnyRef((Object)satellite.getServerPekkoHostname())).withValue("deploy.server.port", ConfigValueFactory.fromAnyRef((Object)satellite.getServerPekkoPort())).withValue("deploy.satellite.metrics.port", ConfigValueFactory.fromAnyRef((Object)satellite.getMetricsPort())).withValue("deploy.satellite.streaming.port", ConfigValueFactory.fromAnyRef((Object)satellite.getPekkoStreamingPort()));
            if (DeployServerUtil.Companion.isPekkoSecured(project)) {
                PekkoSecured secured;
                PekkoSecured pekkoSecured = secured = TlsUtil.Companion.getPekkoSecured(project, DeployServerUtil.Companion.getServerWorkingDir(project));
                if (pekkoSecured != null) {
                    Object object;
                    PekkoSecured it = pekkoSecured;
                    boolean bl = false;
                    PekkoSecured.KeyMeta key = secured.getKeys().get("pekko_ssl_satellite_" + satellite.getName());
                    PekkoSecured.KeyMeta keyMeta = key;
                    newConfiguration = newConfiguration.withValue("deploy.server.ssl.enabled", ConfigValueFactory.fromAnyRef((Object)"yes")).withValue("deploy.server.ssl.key-store", ConfigValueFactory.fromAnyRef((object = key) != null && (object = ((PekkoSecured.KeyMeta)object).keyStoreFile()) != null ? ((File)object).getAbsolutePath() : null)).withValue("deploy.server.ssl.key-store-password", ConfigValueFactory.fromAnyRef((Object)(keyMeta != null ? keyMeta.getKeyStorePassword() : null))).withValue("deploy.server.ssl.trust-store", ConfigValueFactory.fromAnyRef((Object)secured.trustStoreFile().getAbsolutePath())).withValue("deploy.server.ssl.trust-store-password", ConfigValueFactory.fromAnyRef((Object)secured.getTruststorePassword()));
                    PekkoSecured.KeyMeta keyMeta2 = key;
                    newConfiguration = newConfiguration.withValue("deploy.server.ssl.key-password", ConfigValueFactory.fromAnyRef((Object)(keyMeta2 != null ? keyMeta2.getKeyPassword() : null)));
                }
            }
            String string = newConfiguration.root().render(options);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
            FilesKt.writeText$default((File)satelliteConf, (String)string, null, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

