/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.setup;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.constant.ClusterProfileName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.profiles.HelmProfile;
import ai.digital.integration.server.common.domain.profiles.OperatorProfile;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.AwsOpenshiftProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\r\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0014J\r\u0010\u0015\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0014J\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\b\u0010\u0018\u001a\u00020\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lai/digital/integration/server/common/cluster/setup/AwsOpenshiftHelper;", "Lai/digital/integration/server/common/cluster/Helper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "profile", "Lai/digital/integration/server/common/domain/profiles/Profile;", "<init>", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;Lai/digital/integration/server/common/domain/profiles/Profile;)V", "getProfile", "()Lai/digital/integration/server/common/domain/profiles/Profile;", "getProvider", "Lai/digital/integration/server/common/domain/providers/AwsOpenshiftProvider;", "launchCluster", "", "getApiServerUrl", "", "getOcLogin", "", "Lorg/jspecify/annotations/Nullable;", "getOcPassword", "ocLogin", "ocLogout", "createOcContext", "getStorageClass", "integration-server-gradle-plugin"})
public class AwsOpenshiftHelper
extends Helper {
    @NotNull
    private final Profile profile;

    public AwsOpenshiftHelper(@NotNull Project project, @NotNull ProductName productName, @NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        super(project, productName);
        this.profile = profile;
    }

    @NotNull
    public final Profile getProfile() {
        return this.profile;
    }

    @Override
    @NotNull
    public AwsOpenshiftProvider getProvider() {
        AwsOpenshiftProvider awsOpenshiftProvider;
        String profileName = this.getProfileName();
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.OPERATOR.getProfileName())) {
            Profile profile = this.profile;
            Intrinsics.checkNotNull((Object)profile, (String)"null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.OperatorProfile");
            OperatorProfile operatorProfile = (OperatorProfile)profile;
            awsOpenshiftProvider = operatorProfile.getAwsOpenshift();
        } else if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.HELM.getProfileName())) {
            Profile profile = this.profile;
            Intrinsics.checkNotNull((Object)profile, (String)"null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.HelmProfile");
            HelmProfile helmProfile = (HelmProfile)profile;
            awsOpenshiftProvider = helmProfile.getAwsOpenshift();
        } else {
            throw new IllegalArgumentException("Provided profile name `" + profileName + "` is not supported");
        }
        return awsOpenshiftProvider;
    }

    public final void launchCluster() {
        this.createOcContext();
    }

    @NotNull
    public final String getApiServerUrl() {
        Object object = this.getProvider().getApiServerURL().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (String)object;
    }

    @Nullable
    public final Object getOcLogin() {
        return this.getProject().property("ocLogin");
    }

    @Nullable
    public final Object getOcPassword() {
        return this.getProject().property("ocPassword");
    }

    public final void ocLogin() {
        this.exec("oc login " + this.getApiServerUrl() + " --username " + this.getOcLogin() + " --password \"" + this.getOcPassword() + "\"");
    }

    public final void ocLogout() {
        try {
            this.exec("oc logout");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void createOcContext() {
        this.getProject().getLogger().lifecycle("Updating kube config for Open Shift");
        this.exec("export KUBECONFIG=~/.kube/config");
        this.ocLogin();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse((Object)"aws-efs");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        return (String)object;
    }
}

