/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.AwsEksHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.AwsEksProvider;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/digital/integration/server/common/cluster/operator/AwsEksOperatorHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "<init>", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "awsEksHelper", "Lai/digital/integration/server/common/cluster/setup/AwsEksHelper;", "launchCluster", "", "updateOperator", "installCluster", "shutdownCluster", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "getProviderHomePath", "", "getProvider", "Lai/digital/integration/server/common/domain/providers/AwsEksProvider;", "getStorageClass", "updateInfrastructure", "getFqdn", "getDbStorageClass", "getMqStorageClass", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "integration-server-gradle-plugin"})
public class AwsEksOperatorHelper
extends OperatorHelper {
    @NotNull
    private final AwsEksHelper awsEksHelper;

    public AwsEksOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.awsEksHelper = new AwsEksHelper(project, productName, this.getProfile());
    }

    public final void launchCluster() {
        this.awsEksHelper.launchCluster();
    }

    public final void updateOperator() {
        Object object = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.cleanUpCluster((Duration)object);
        this.updateInfrastructure();
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorEnvironment();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
    }

    public final void installCluster() {
        this.applyYamlFiles();
        Helper helper = this;
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Helper.waitForDeployment$default(helper, string, ((Number)object2).intValue(), false, 4, null);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        this.waitForWorkerPods(((Number)object4).intValue());
        this.createClusterMetadata();
        AwsEksHelper.updateRoute53$default(this.awsEksHelper, this.getFqdn(), null, 2, null);
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
    }

    public final void shutdownCluster() {
        this.undeployCluster();
        this.awsEksHelper.destroyClusterOnShutdown();
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkNotNullParameter((Object)crValuesFile, (String)"crValuesFile");
        Pair[] pairArray = new Pair[2];
        String[] stringArray = new String[]{this.getFqdn()};
        pairArray[0] = TuplesKt.to((Object)"spec.ingress.hosts", (Object)stringArray);
        pairArray[1] = TuplesKt.to((Object)"spec.rabbitmq.persistence.storageClass", (Object)"gp2");
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, crValuesFile, pairs, null, false, 4, null);
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-aws-eks";
    }

    @Override
    @NotNull
    public AwsEksProvider getProvider() {
        return this.getProfile().getAwsEks();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return this.awsEksHelper.getStorageClass();
    }

    @Override
    public void updateInfrastructure() {
        super.updateInfrastructure();
        InfrastructureInfo infraInfo = this.getCurrentContextInfo();
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        AwsEksProvider awsEksProvider = this.getProvider();
        Pair[] pairArray = new Pair[6];
        String string = infraInfo.getApiServerURL();
        Intrinsics.checkNotNull((Object)string);
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = infraInfo.getCaCert();
        Intrinsics.checkNotNull((Object)string2);
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].accessKey", (Object)awsEksProvider.getAwsAccessKey());
        pairArray[3] = TuplesKt.to((Object)"spec[0].children[0].accessSecret", (Object)awsEksProvider.getAwsSecretKey());
        pairArray[4] = TuplesKt.to((Object)"spec[0].children[0].regionName", (Object)awsEksProvider.getRegion().get());
        pairArray[5] = TuplesKt.to((Object)"spec[0].children[0].clusterName", (Object)awsEksProvider.getClusterName().get());
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 12, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        Object object = this.getProvider().getStack().get();
        String string = this.getName();
        String string2 = this.getNamespace();
        if (string2 == null) {
            string2 = Profile.Companion.getDEFAULT_NAMESPACE_NAME();
        }
        return object + "-" + string + "-" + string2 + ".digitalai-testing.com";
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        return "gp2";
    }

    @Override
    @NotNull
    public String getMqStorageClass() {
        return "gp2";
    }

    @Override
    @NotNull
    public InfrastructureInfo getCurrentContextInfo() {
        return this.getKubectlHelper().getCurrentContextInfo(true);
    }
}

