/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.helm;

import ai.digital.integration.server.common.cluster.helm.HelmHelper;
import ai.digital.integration.server.common.cluster.setup.AwsOpenshiftHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.providers.AwsOpenshiftProvider;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lai/digital/integration/server/common/cluster/helm/AwsOpenshiftHelmHelper;", "Lai/digital/integration/server/common/cluster/helm/HelmHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "<init>", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "awsOpenshiftHelper", "Lai/digital/integration/server/common/cluster/setup/AwsOpenshiftHelper;", "launchCluster", "", "setupHelmValues", "helmInstallCluster", "shutdownCluster", "getProvider", "Lai/digital/integration/server/common/domain/providers/AwsOpenshiftProvider;", "updateCustomHelmValues", "valuesFile", "Ljava/io/File;", "getStorageClass", "", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "hasIngress", "", "getFqdn", "getWorkerPodName", "position", "", "getMasterPodName", "getContextPath", "integration-server-gradle-plugin"})
public class AwsOpenshiftHelmHelper
extends HelmHelper {
    @NotNull
    private final AwsOpenshiftHelper awsOpenshiftHelper;

    public AwsOpenshiftHelmHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.awsOpenshiftHelper = new AwsOpenshiftHelper(project, productName, this.getProfile());
    }

    public final void launchCluster() {
        this.awsOpenshiftHelper.launchCluster();
    }

    public final void setupHelmValues() {
        this.updateHelmValuesYaml();
        this.updateHelmDependency();
    }

    public final void helmInstallCluster() {
        this.installCluster();
        this.awsOpenshiftHelper.ocLogin();
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        this.waitForDeployment(string, ((Number)object2).intValue(), true);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        this.waitForWorkerPods(((Number)object4).intValue());
        this.createClusterMetadata();
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
    }

    public final void shutdownCluster() {
        this.awsOpenshiftHelper.ocLogin();
        this.helmCleanUpCluster();
        this.getKubectlHelper().deleteAllPVCs();
        this.awsOpenshiftHelper.ocLogout();
    }

    @Override
    @NotNull
    public AwsOpenshiftProvider getProvider() {
        return this.getProfile().getAwsOpenshift();
    }

    @Override
    public void updateCustomHelmValues(@NotNull File valuesFile) {
        Intrinsics.checkNotNullParameter((Object)valuesFile, (String)"valuesFile");
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return this.awsOpenshiftHelper.getStorageClass();
    }

    @Override
    @NotNull
    public KubeCtlHelper getKubectlHelper() {
        return new KubeCtlHelper(this.getProject(), this.getNamespace(), true);
    }

    @Override
    public boolean hasIngress() {
        return false;
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.awsOpenshiftHelper.getFqdn();
    }

    @Override
    @NotNull
    public String getWorkerPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + "-ocp-worker-" + position;
    }

    @Override
    @NotNull
    public String getMasterPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + "-ocp-" + this.getMasterPodNameSuffix(position);
    }

    @Override
    @NotNull
    public String getContextPath() {
        return "route.path";
    }
}

