/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tasks.infrastructure;

import ai.digital.integration.server.common.domain.Infrastructure;
import ai.digital.integration.server.common.util.InfrastructureUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/digital/integration/server/common/tasks/infrastructure/InfrastructureStartTask;", "Lorg/gradle/api/DefaultTask;", "execOperations", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "getDescription", "", "run", "", "startDockerContainers", "infrastructure", "Lai/digital/integration/server/common/domain/Infrastructure;", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nInfrastructureStartTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfrastructureStartTask.kt\nai/digital/integration/server/common/tasks/infrastructure/InfrastructureStartTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1869#2,2:59\n1869#2,2:61\n*S KotlinDebug\n*F\n+ 1 InfrastructureStartTask.kt\nai/digital/integration/server/common/tasks/infrastructure/InfrastructureStartTask\n*L\n34#1:59,2\n46#1:61,2\n*E\n"})
public abstract class InfrastructureStartTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    public static final String NAME = "infrastructureStart";

    @Inject
    public InfrastructureStartTask(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
    }

    @NotNull
    public String getDescription() {
        return "Starts infrastructures.";
    }

    @TaskAction
    public final void run() {
        this.getProject().getLogger().lifecycle("Starting infrastructures.");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable $this$forEach$iv = InfrastructureUtil.Companion.getInfrastructures(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Infrastructure infrastructure = (Infrastructure)element$iv;
            boolean bl = false;
            if (!infrastructure.isDockerBased()) continue;
            this.startDockerContainers(infrastructure);
        }
    }

    private final void startDockerContainers(Infrastructure infrastructure) {
        this.getProject().getLogger().lifecycle("Starting infrastructure " + infrastructure.getName() + " using `docker-compose`");
        ArrayList<String> dockerComposeArgs = new ArrayList<String>();
        Iterable $this$forEach$iv = infrastructure.getDockerComposeFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String dockerComposeFile = (String)element$iv;
            boolean bl = false;
            dockerComposeArgs.add("-f");
            dockerComposeArgs.add(dockerComposeFile);
        }
        dockerComposeArgs.add("up");
        dockerComposeArgs.add("-d");
        this.execOperations.exec(new Action(dockerComposeArgs){
            final /* synthetic */ ArrayList<String> $dockerComposeArgs;
            {
                this.$dockerComposeArgs = $dockerComposeArgs;
            }

            public final void execute(ExecSpec $this$exec) {
                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                $this$exec.setExecutable("docker-compose");
                $this$exec.setArgs((List)this.$dockerComposeArgs);
            }
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/common/tasks/infrastructure/InfrastructureStartTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

