/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.domain;

import ai.digital.integration.server.common.util.TlsUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013R\u0014\u0010\u0006\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lai/digital/integration/server/common/domain/PekkoSecured;", "", "serverWorkingDir", "", "<init>", "(Ljava/lang/String;)V", "trustStoreName", "getTrustStoreName", "()Ljava/lang/String;", "truststorePassword", "getTruststorePassword", "confWorkDirPath", "trustStoreFilePath", "keys", "", "Lai/digital/integration/server/common/domain/PekkoSecured$KeyMeta;", "getKeys", "()Ljava/util/Map;", "confWorkDir", "Ljava/io/File;", "trustStoreFile", "Companion", "KeyMeta", "integration-server-gradle-plugin"})
public final class PekkoSecured {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String trustStoreName;
    @NotNull
    private final String truststorePassword;
    @NotNull
    private final String confWorkDirPath;
    @NotNull
    private final String trustStoreFilePath;
    @NotNull
    private final Map<String, KeyMeta> keys;
    @NotNull
    public static final String KEYSTORE_TYPE = "jks";
    @NotNull
    public static final String KEYSTORE_TYPE_EXTENSION = "jks";
    @NotNull
    public static final String MASTER_KEY_NAME = "pekko_ssl_master_";
    @NotNull
    public static final String WORKER_KEY_NAME = "pekko_ssl_worker_";
    @NotNull
    public static final String SATELLITE_KEY_NAME = "pekko_ssl_satellite_";
    @NotNull
    public static final String TRUSTSTORE_NAME = "pekko_ssl_truststore_";

    public PekkoSecured(@NotNull String serverWorkingDir) {
        Intrinsics.checkNotNullParameter((Object)serverWorkingDir, (String)"serverWorkingDir");
        this.trustStoreName = TRUSTSTORE_NAME;
        this.truststorePassword = TlsUtil.Companion.generatePassword(this.trustStoreName);
        this.confWorkDirPath = serverWorkingDir + "/conf";
        this.trustStoreFilePath = this.confWorkDir() + "/" + this.trustStoreName + ".jks";
        this.keys = new LinkedHashMap();
    }

    @NotNull
    public final String getTrustStoreName() {
        return this.trustStoreName;
    }

    @NotNull
    public final String getTruststorePassword() {
        return this.truststorePassword;
    }

    @NotNull
    public final Map<String, KeyMeta> getKeys() {
        return this.keys;
    }

    @NotNull
    public final File confWorkDir() {
        return new File(this.confWorkDirPath);
    }

    @NotNull
    public final File trustStoreFile() {
        return new File(this.trustStoreFilePath);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/common/domain/PekkoSecured$Companion;", "", "<init>", "()V", "KEYSTORE_TYPE", "", "KEYSTORE_TYPE_EXTENSION", "MASTER_KEY_NAME", "WORKER_KEY_NAME", "SATELLITE_KEY_NAME", "TRUSTSTORE_NAME", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\u0003R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u0014"}, d2={"Lai/digital/integration/server/common/domain/PekkoSecured$KeyMeta;", "", "confWorkDir", "Ljava/io/File;", "keyStoreName", "", "<init>", "(Ljava/io/File;Ljava/lang/String;)V", "keyStoreFile", "keyStorePassword", "getKeyStorePassword", "()Ljava/lang/String;", "setKeyStorePassword", "(Ljava/lang/String;)V", "keyPassword", "getKeyPassword", "setKeyPassword", "keyStoreFilePath", "getKeyStoreFilePath", "setKeyStoreFilePath", "integration-server-gradle-plugin"})
    public static final class KeyMeta {
        @NotNull
        private String keyStorePassword;
        @NotNull
        private String keyPassword;
        @NotNull
        private String keyStoreFilePath;

        public KeyMeta(@NotNull File confWorkDir, @NotNull String keyStoreName) {
            Intrinsics.checkNotNullParameter((Object)confWorkDir, (String)"confWorkDir");
            Intrinsics.checkNotNullParameter((Object)keyStoreName, (String)"keyStoreName");
            this.keyStorePassword = TlsUtil.Companion.generatePassword("s" + keyStoreName);
            this.keyPassword = TlsUtil.Companion.generatePassword("k" + keyStoreName);
            this.keyStoreFilePath = confWorkDir + "/" + keyStoreName + ".jks";
        }

        @NotNull
        public final File keyStoreFile() {
            return new File(this.keyStoreFilePath);
        }

        @NotNull
        public final String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public final void setKeyStorePassword(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.keyStorePassword = string;
        }

        @NotNull
        public final String getKeyPassword() {
            return this.keyPassword;
        }

        public final void setKeyPassword(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.keyPassword = string;
        }

        @NotNull
        public final String getKeyStoreFilePath() {
            return this.keyStoreFilePath;
        }

        public final void setKeyStoreFilePath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.keyStoreFilePath = string;
        }
    }
}

