/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.AzureAksHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.AzureAksProvider;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u0006\u0010\u001d\u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/digital/integration/server/common/cluster/operator/AzureAksOperatorHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "<init>", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "azureAksHelper", "Lai/digital/integration/server/common/cluster/setup/AzureAksHelper;", "launchCluster", "", "updateOperator", "installCluster", "shutdownCluster", "updateInfrastructure", "infraInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "getProviderHomePath", "", "getProvider", "Lai/digital/integration/server/common/domain/providers/AzureAksProvider;", "getStorageClass", "getDbStorageClass", "getFqdn", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "getCurrentContextInfo", "getAccessToken", "integration-server-gradle-plugin"})
public class AzureAksOperatorHelper
extends OperatorHelper {
    @NotNull
    private final AzureAksHelper azureAksHelper;

    public AzureAksOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.azureAksHelper = new AzureAksHelper(project, productName, this.getProfile());
    }

    public final void launchCluster() {
        this.azureAksHelper.launchCluster();
    }

    public final void updateOperator() {
        Object object = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.cleanUpCluster((Duration)object);
        InfrastructureInfo kubeContextInfo = this.getCurrentContextInfo();
        this.updateInfrastructure(kubeContextInfo);
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorEnvironment();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
    }

    public final void installCluster() {
        this.applyYamlFiles();
        this.turnOnLogging();
        Helper helper = this;
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Helper.waitForDeployment$default(helper, string, ((Number)object2).intValue(), false, 4, null);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        this.waitForWorkerPods(((Number)object4).intValue());
        this.createClusterMetadata();
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
        this.turnOffLogging();
    }

    public final void shutdownCluster() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String name = (String)object;
        String groupName = this.azureAksHelper.resourceGroupName(name);
        Object object2 = azureAksProvider.getLocation().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String location = (String)object2;
        boolean existsResourceGroup = this.azureAksHelper.existsResourceGroup(groupName, location);
        if (existsResourceGroup) {
            this.undeployCluster();
        }
        this.azureAksHelper.destroyClusterOnShutdown(existsResourceGroup, name, groupName, location);
    }

    private final void updateInfrastructure(InfrastructureInfo infraInfo) {
        super.updateInfrastructure();
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        Pair[] pairArray = new Pair[4];
        String string = infraInfo.getApiServerURL();
        Intrinsics.checkNotNull((Object)string);
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].apiServerURL", (Object)string);
        String string2 = infraInfo.getCaCert();
        Intrinsics.checkNotNull((Object)string2);
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].caCert", (Object)string2);
        String string3 = infraInfo.getTlsCert();
        Intrinsics.checkNotNull((Object)string3);
        pairArray[2] = TuplesKt.to((Object)"spec[0].children[0].tlsCert", (Object)string3);
        String string4 = infraInfo.getTlsPrivateKey();
        Intrinsics.checkNotNull((Object)string4);
        pairArray[3] = TuplesKt.to((Object)"spec[0].children[0].tlsPrivateKey", (Object)string4);
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 12, null);
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-azure-aks";
    }

    @Override
    @NotNull
    public AzureAksProvider getProvider() {
        return this.getProfile().getAzureAks();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return this.azureAksHelper.getStorageClass();
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        return this.azureAksHelper.getDbStorageClass();
    }

    @Override
    @NotNull
    public String getFqdn() {
        AzureAksProvider azureAksProvider = this.getProvider();
        Object object = azureAksProvider.getLocation().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String location = (String)object;
        return this.getHost() + "." + location + ".cloudapp.azure.com";
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkNotNullParameter((Object)crValuesFile, (String)"crValuesFile");
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"spec.nginx-ingress-controller.service.annotations", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"service.beta.kubernetes.io/azure-dns-label-name", (Object)this.getHost())));
        pairArray[1] = TuplesKt.to((Object)"spec.haproxy-ingress.controller.service.annotations", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"service.beta.kubernetes.io/azure-dns-label-name", (Object)this.getHost())));
        String[] stringArray = new String[]{this.getFqdn()};
        pairArray[2] = TuplesKt.to((Object)"spec.ingress.hosts", (Object)stringArray);
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, crValuesFile, pairs, null, false, 4, null);
    }

    @Override
    @NotNull
    public InfrastructureInfo getCurrentContextInfo() {
        return KubeCtlHelper.getCurrentContextInfo$default(this.getKubectlHelper(), false, 1, null);
    }

    @NotNull
    public final String getAccessToken() {
        String azToken = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "az account get-access-token -o yaml", null, false, false, 0L, 60, null);
        Map azConfigMap = (Map)new ObjectMapper((JsonFactory)YAMLFactory.builder().build()).readValue(azToken, Map.class);
        Intrinsics.checkNotNull((Object)azConfigMap);
        Object v = azConfigMap.get("accessToken");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)v;
    }
}

