/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.release.util;

import ai.digital.integration.server.common.domain.Cluster;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.release.ReleaseIntegrationServerExtension;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/release/util/ReleaseServerUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class ReleaseServerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u001f\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010%\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010&\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010(J\u000e\u0010)\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010*\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010+\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010-\u001a\u00020\u0005H\u0002\u00a8\u0006."}, d2={"Lai/digital/integration/server/release/util/ReleaseServerUtil$Companion;", "", "<init>", "()V", "getHttpHost", "", "getUrl", "project", "Lorg/gradle/api/Project;", "composeUrl", "path", "isTls", "", "getCluster", "Lai/digital/integration/server/common/domain/Cluster;", "isClusterEnabled", "getConfDir", "Ljava/io/File;", "getLicenseFile", "readReleaseServerConfProperty", "key", "getServer", "Lai/digital/integration/server/common/domain/Server;", "isNonXlDeploy", "server", "getServerWorkingDir", "getRelativePathInIntegrationServerDist", "Ljava/nio/file/Path;", "relativePath", "isDockerBased", "getServerVersion", "getHttpPort", "", "getDebugPort", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/domain/Server;)Ljava/lang/Integer;", "grantPermissionsToIntegrationServerFolder", "", "isReleaseServerDefined", "waitForBoot", "process", "Ljava/lang/Process;", "getDockerImageVersion", "getDockerServiceName", "runDockerBasedInstance", "getResolvedDockerFile", "dockerServerRelativePath", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nReleaseServerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseServerUtil.kt\nai/digital/integration/server/release/util/ReleaseServerUtil$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,188:1\n230#2,2:189\n1321#3,2:191\n*S KotlinDebug\n*F\n+ 1 ReleaseServerUtil.kt\nai/digital/integration/server/release/util/ReleaseServerUtil$Companion\n*L\n69#1:189,2\n129#1:191,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getHttpHost() {
            return "localhost";
        }

        private final String getUrl(Project project) {
            Server server = this.getServer(project);
            String hostName = this.getHttpHost();
            return this.isTls(project) ? "https://" + hostName + ":" + server.getHttpPort() + server.getContextRoot() : "http://" + hostName + ":" + server.getHttpPort() + server.getContextRoot();
        }

        private final String composeUrl(Project project, String path) {
            String url = this.getUrl(project);
            String separator = "/";
            if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                separator = "";
                if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                    url = StringsKt.removeSuffix((String)url, (CharSequence)"/");
                }
            }
            return url + separator + path;
        }

        public final boolean isTls(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getServer(project).getTls();
        }

        @NotNull
        public final Cluster getCluster(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = ReleaseExtensionUtil.Companion.getExtension(project).getCluster().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (Cluster)object;
        }

        public final boolean isClusterEnabled(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getCluster(project).getEnable();
        }

        @NotNull
        public final File getConfDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String[] stringArray = new String[]{"conf"};
            File file = Paths.get(this.getServerWorkingDir(project), stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @NotNull
        public final File getLicenseFile(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String[] stringArray = new String[]{"xl-release-license.lic"};
            File file = Paths.get(this.getConfDir(project).getAbsolutePath(), stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @NotNull
        public final String readReleaseServerConfProperty(@NotNull Project project, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            File serverConf = Paths.get(this.getServerWorkingDir(project) + "/conf/xl-release-server.conf", new String[0]).toFile();
            Intrinsics.checkNotNull((Object)serverConf);
            return PropertiesUtil.Companion.readProperty(serverConf, key);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Server getServer(@NotNull Project project) {
            Object element$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getExtensions().getByType(ReleaseIntegrationServerExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
            ReleaseIntegrationServerExtension ext = (ReleaseIntegrationServerExtension)object;
            Iterable $this$first$iv = (Iterable)ext.getServers();
            boolean $i$f$first = false;
            Iterator iterator = $this$first$iv.iterator();
            do {
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                element$iv = iterator.next();
                Server server = (Server)element$iv;
                boolean bl2 = false;
                if (!server.getPreviousInstallation()) {
                    Intrinsics.checkNotNull((Object)server);
                    if (Companion.isNonXlDeploy(server)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            Object t = element$iv;
            Intrinsics.checkNotNullExpressionValue(t, (String)"first(...)");
            Server server = (Server)t;
            server.setDebugPort(this.getDebugPort(project, server));
            server.setHttpPort(this.getHttpPort(project, server));
            server.setVersion(this.getServerVersion(project, server));
            String string = server.getDockerImage();
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                server.setRuntimeDirectory(null);
            }
            if (!StringsKt.startsWith$default((String)server.getContextRoot(), (String)"/", (boolean)false, (int)2, null)) {
                server.setContextRoot("/" + server + ".contextRoot");
            }
            return server;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNonXlDeploy(Server server) {
            if (server.getDockerImage() == null) return true;
            String string = server.getDockerImage();
            if (string == null) return false;
            if (StringsKt.endsWith$default((String)string, (String)"xl-deploy", (boolean)false, (int)2, null)) return false;
            return true;
        }

        @NotNull
        public final String getServerWorkingDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Path workDir = this.getRelativePathInIntegrationServerDist(project, "release");
            return ((Object)workDir.toAbsolutePath()).toString();
        }

        private final Path getRelativePathInIntegrationServerDist(Project project, String relativePath) {
            Path path = Paths.get(IntegrationServerUtil.Companion.getDist(project) + "/" + relativePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        public final boolean isDockerBased(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            CharSequence charSequence = this.getServer(project).getDockerImage();
            return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        }

        private final String getServerVersion(Project project, Server server) {
            return project.hasProperty("xlReleaseVersion") ? String.valueOf(project.property("xlReleaseVersion")) : server.getVersion();
        }

        private final int getHttpPort(Project project, Server server) {
            int n;
            if (project.hasProperty("serverHttpPort")) {
                Integer n2 = Integer.valueOf(String.valueOf(project.property("serverHttpPort")));
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"valueOf(...)");
                n = ((Number)n2).intValue();
            } else {
                n = server.getHttpPort();
            }
            return n;
        }

        private final Integer getDebugPort(Project project, Server server) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "serverDebugPort", server.getDebugPort()) : null;
        }

        public final void grantPermissionsToIntegrationServerFolder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String workDir = IntegrationServerUtil.Companion.getDist(project);
            Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)new File(workDir), null, (int)1, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                FileUtil.Companion.grantRWPermissions(it);
            }
        }

        public final boolean isReleaseServerDefined(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getExtensions().getByType(ReleaseIntegrationServerExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
            ReleaseIntegrationServerExtension ext = (ReleaseIntegrationServerExtension)object;
            return ext.getServers().size() > 0;
        }

        public final void waitForBoot(@NotNull Project project, @Nullable Process process) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String url = this.composeUrl(project, "/api/extension/metadata");
            Server server = this.getServer(project);
            WaitForBootUtil.Companion.byPort$default(WaitForBootUtil.Companion, project, "Release", url, process, server.getPingRetrySleepTime(), server.getPingTotalTries(), null, 64, null);
        }

        @NotNull
        public final String getDockerImageVersion(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            return server.getDockerImage() + ":" + server.getVersion();
        }

        @NotNull
        public final String getDockerServiceName(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            return "release-" + server.getVersion();
        }

        public final void runDockerBasedInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getObjects().newInstance(ExecOperations.class, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(...)");
            ExecOperations execOperations = (ExecOperations)object;
            execOperations.exec(new Action(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final void execute(ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable("docker-compose");
                    Object[] objectArray = new String[4];
                    objectArray[0] = "-f";
                    Intrinsics.checkNotNullExpressionValue((Object)ReleaseServerUtil.Companion.getResolvedDockerFile(this.$project).toFile().toString(), (String)"toString(...)");
                    objectArray[2] = "up";
                    objectArray[3] = "-d";
                    $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
                }
            });
        }

        @NotNull
        public final Path getResolvedDockerFile(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(project, this.dockerServerRelativePath());
            File serverTemplate = resultComposeFilePath.toFile();
            Intrinsics.checkNotNull((Object)serverTemplate);
            String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)serverTemplate, (Charset)Charsets.UTF_8), (String)"{{RELEASE_SERVER_HTTP_PORT}}", (String)String.valueOf(server.getHttpPort()), (boolean)false, (int)4, null), (String)"{{RELEASE_IMAGE_VERSION}}", (String)this.getDockerImageVersion(project), (boolean)false, (int)4, null), (String)"{{RELEASE_PLUGINS_TO_EXCLUDE}}", (String)CollectionsKt.joinToString$default((Iterable)server.getDefaultOfficialPluginsToExclude(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null), (boolean)false, (int)4, null), (String)"{{RELEASE_VERSION}}", (String)String.valueOf(server.getVersion()), (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)serverTemplate, (String)configuredTemplate, null, (int)2, null);
            return resultComposeFilePath;
        }

        private final String dockerServerRelativePath() {
            return "release/server-docker-compose.yaml";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

