/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cluster.helm;

import ai.digital.integration.server.common.cluster.helm.HelmHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.util.GitUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/helm/ProvideDeployKubernetesHelmChartTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "launch", "", "cloneRepository", "branch", "", "Companion", "integration-server-gradle-plugin"})
public class ProvideDeployKubernetesHelmChartTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "provideDeployKubernetesHelmChart";

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        HelmHelper helmHelper = HelmHelper.Companion.getHelmHelper(project, ProductName.DEPLOY);
        Object object = helmHelper.getProvider().getHelmBranch().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String branch = (String)object;
        this.getProject().getLogger().lifecycle("Checking out xl-deploy-kubernetes-helm-chart branch " + branch);
        this.cloneRepository(branch);
    }

    private final void cloneRepository(String branch) {
        Path path = ((Directory)this.getProject().getLayout().getBuildDirectory().get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        GitUtil.Companion.checkout("xl-deploy-kubernetes-helm-chart", path, branch);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/helm/ProvideDeployKubernetesHelmChartTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

