/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/util/DockerUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DockerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0005\u00a8\u0006\u0017"}, d2={"Lai/digital/integration/server/common/util/DockerUtil$Companion;", "", "<init>", "()V", "execute", "", "project", "Lorg/gradle/api/Project;", "args", "", "logOutput", "", "throwErrorOnFailure", "inspect", "format", "instanceId", "findContainerIdByName", "containerName", "dockerLogs", "lastUpdate", "Ljava/time/LocalDateTime;", "getContainerImageByName", "getCurrentTimeForDockerImageTag", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nDockerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerUtil.kt\nai/digital/integration/server/common/util/DockerUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String execute(@NotNull Project project, @NotNull List<String> args, boolean logOutput, boolean throwErrorOnFailure) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "docker " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, logOutput, throwErrorOnFailure, 0L, 36, null);
        }

        public static /* synthetic */ String execute$default(Companion companion, Project project, List list, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            return companion.execute(project, list, bl, bl2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String inspect(@NotNull Project project, @NotNull String format, @NotNull String instanceId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
            Object[] objectArray = new String[]{"docker", "inspect", "-f", format, instanceId};
            List command = CollectionsKt.listOf((Object[])objectArray);
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            try {
                Process process = processBuilder.start();
                InputStream inputStream = process.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                Closeable closeable = inputStream;
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    object2 = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object output = object2;
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    InputStream inputStream2 = process.getErrorStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
                    object2 = inputStream2;
                    Object object3 = Charsets.UTF_8;
                    Object object4 = new InputStreamReader((InputStream)object2, (Charset)object3);
                    int n2 = 8192;
                    object2 = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n2);
                    object3 = null;
                    try {
                        BufferedReader it = (BufferedReader)object2;
                        boolean bl = false;
                        object4 = TextStreamsKt.readText((Reader)it);
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                    }
                    Object error = object4;
                    project.getLogger().error("Docker inspect failed with exit code " + exitCode + ": " + (String)error);
                    throw new RuntimeException("Docker inspect failed: " + (String)error);
                }
                return ((Object)StringsKt.trim((CharSequence)((CharSequence)output))).toString();
            }
            catch (Exception e) {
                project.getLogger().error("Failed to execute docker inspect", (Throwable)e);
                throw e;
            }
        }

        private final String findContainerIdByName(Project project, String containerName) {
            Object[] objectArray = new String[]{"ps", "-a", "-f", "name=" + containerName, "--format", "{{.ID}}"};
            ArrayList args = CollectionsKt.arrayListOf((Object[])objectArray);
            return ((Object)StringsKt.trim((CharSequence)ai.digital.integration.server.common.util.DockerUtil$Companion.execute$default(this, project, args, false, false, 8, null))).toString();
        }

        @NotNull
        public final String dockerLogs(@NotNull Project project, @NotNull String containerName, @NotNull LocalDateTime lastUpdate) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
            Intrinsics.checkNotNullParameter((Object)lastUpdate, (String)"lastUpdate");
            DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            String containerId = this.findContainerIdByName(project, containerName);
            Object[] objectArray = new String[]{"logs", containerId, "--since", lastUpdate.format(formatter)};
            ArrayList args = CollectionsKt.arrayListOf((Object[])objectArray);
            return ai.digital.integration.server.common.util.DockerUtil$Companion.execute$default(this, project, args, false, false, 8, null);
        }

        @NotNull
        public final String getContainerImageByName(@NotNull Project project, @NotNull String containerName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
            return this.inspect(project, "{{.Config.Image}}", containerName);
        }

        @NotNull
        public final String getCurrentTimeForDockerImageTag() {
            String string = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

