/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.worker;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\u0005H\u0007\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/ShutdownWorkersTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "killWorkerProcessByPort", "", "port", "", "shutdownWorkers", "stop", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nShutdownWorkersTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShutdownWorkersTask.kt\nai/digital/integration/server/deploy/tasks/worker/ShutdownWorkersTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1869#2,2:111\n*S KotlinDebug\n*F\n+ 1 ShutdownWorkersTask.kt\nai/digital/integration/server/deploy/tasks/worker/ShutdownWorkersTask\n*L\n99#1:111,2\n*E\n"})
public class ShutdownWorkersTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "shutdownWorkers";

    public ShutdownWorkersTask() {
        Object[] objectArray = new Object[]{"shutdownMq"};
        this.dependsOn(objectArray);
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
    }

    private final void killWorkerProcessByPort(String port) {
        try {
            this.getProject().getLogger().lifecycle("Attempting to kill worker process on port " + port);
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String osName = string2;
            if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{"cmd", "/c", "netstat -ano | findstr :" + port};
                ProcessBuilder findProcess = new ProcessBuilder(stringArray);
                findProcess.redirectErrorStream(true);
                Process findResult = findProcess.start();
                InputStream inputStream = findResult.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                Reader reader = new InputStreamReader(inputStream2, charset);
                int n = 8192;
                String output = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                findResult.waitFor();
                Regex pidPattern = new Regex("LISTENING\\s+(\\d+)");
                MatchResult match = Regex.find$default((Regex)pidPattern, (CharSequence)output, (int)0, (int)2, null);
                if (match != null) {
                    String pid = (String)match.getGroupValues().get(1);
                    this.getProject().getLogger().lifecycle("Found worker process " + pid + " on port " + port + ", attempting to kill");
                    String[] stringArray2 = new String[]{"taskkill", "/F", "/PID", pid};
                    ProcessBuilder killProcess = new ProcessBuilder(stringArray2);
                    killProcess.redirectErrorStream(true);
                    Process killResult = killProcess.start();
                    killResult.waitFor(10L, TimeUnit.SECONDS);
                    this.getProject().getLogger().lifecycle("Forcefully killed worker process " + pid);
                }
            } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"linux", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null)) {
                Object findResult = new String[]{"sh", "-c", "lsof -ti:" + port};
                ProcessBuilder findProcess = new ProcessBuilder((String[])findResult);
                findProcess.redirectErrorStream(true);
                findResult = findProcess.start();
                InputStream inputStream = ((Process)findResult).getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                InputStream pidPattern = inputStream;
                String[] match = Charsets.UTF_8;
                Reader reader = new InputStreamReader(pidPattern, (Charset)match);
                int n = 8192;
                String pid = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))))).toString();
                ((Process)findResult).waitFor();
                if (((CharSequence)pid).length() > 0) {
                    this.getProject().getLogger().lifecycle("Found worker process " + pid + " on port " + port + ", attempting to kill");
                    match = new String[]{"kill", "-9", pid};
                    ProcessBuilder killProcess = new ProcessBuilder(match);
                    killProcess.redirectErrorStream(true);
                    Process killResult = killProcess.start();
                    killResult.waitFor(10L, TimeUnit.SECONDS);
                    this.getProject().getLogger().lifecycle("Forcefully killed worker process " + pid);
                }
            }
            TimeUnit.SECONDS.sleep(2L);
        }
        catch (Exception e) {
            this.getProject().getLogger().warn("Failed to kill worker process on port " + port + ": " + e.getMessage());
        }
    }

    private final void shutdownWorkers() {
        boolean gracefulShutdownSucceeded = false;
        try {
            this.getProject().getLogger().lifecycle("About to shutdown all workers");
            HttpClient client = HttpClient.newHttpClient();
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            HttpRequest request = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null), "/deployit/workers", false, 2, null), null, null, 6, null).DELETE().build();
            client.send(request, HttpResponse.BodyHandlers.ofString());
            this.getProject().getLogger().lifecycle("Workers shutdown successfully");
            gracefulShutdownSucceeded = true;
        }
        catch (Exception ignore) {
            this.getProject().getLogger().lifecycle("Workers did not respond to graceful shutdown");
        }
        if (!gracefulShutdownSucceeded) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Iterable $this$forEach$iv = WorkerUtil.Companion.getWorkers(project);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Worker worker = (Worker)element$iv;
                boolean bl = false;
                this.killWorkerProcessByPort(worker.getPort());
            }
        }
    }

    @TaskAction
    public final void stop() {
        this.shutdownWorkers();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/ShutdownWorkersTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

