/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server.operator;

import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/StartDeployServerForOperatorInstanceTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "clusterUtil", "Lai/digital/integration/server/common/cluster/util/OperatorUtil;", "start", "", "server", "Lai/digital/integration/server/common/domain/Server;", "allowToWriteMountedHostFolders", "launch", "Companion", "integration-server-gradle-plugin"})
public class StartDeployServerForOperatorInstanceTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OperatorUtil clusterUtil;
    @NotNull
    public static final String NAME = "startDeployServerForOperatorInstance";

    public StartDeployServerForOperatorInstanceTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.clusterUtil = new OperatorUtil(project);
        this.setGroup("Integration Server");
        Object[] objectArray = new String[]{"operatorCentralConfiguration", "prepareOperatorServer", "serverCopyOverlays"};
        List dependencies = CollectionsKt.mutableListOf((Object[])objectArray);
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), arg_0 -> StartDeployServerForOperatorInstanceTask._init_$lambda$0(dependencies, arg_0)));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void start(Server server) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Integer currentPort = DeployServerUtil.Companion.getDockerContainerPort(project, server, 4516);
        if (currentPort != null) {
            int n = server.getHttpPort();
            if (currentPort == n) {
                this.getProject().getLogger().lifecycle("Deploy Server " + server.getName() + " " + server.getVersion() + " on port " + server.getHttpPort() + " is already running. Not starting it!");
                return;
            }
        }
        this.getProject().getLogger().lifecycle("Deploy Server " + server.getName() + " " + server.getVersion() + " on port " + server.getHttpPort() + " is not running. Starting it!");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        DeployServerUtil.Companion.runDockerBasedInstance(project2, server);
    }

    private final void allowToWriteMountedHostFolders() {
        this.clusterUtil.grantPermissionsToIntegrationServerFolder();
    }

    @TaskAction
    public final void launch() {
        Server server = this.clusterUtil.getOperatorServer();
        this.getProject().getLogger().lifecycle("About to launch Deploy Server " + server.getName() + " " + server.getVersion() + " on port " + server.getHttpPort() + ".");
        this.allowToWriteMountedHostFolders();
        this.start(server);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        new OperatorUtil(project).waitForBoot(server);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        File dockerComposeFile = DeployServerUtil.Companion.getResolvedDockerFile(project2, server).toFile();
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        Intrinsics.checkNotNull((Object)dockerComposeFile);
        DockerComposeUtil.Companion.allowToCleanMountedFiles(project3, ProductName.DEPLOY, server, dockerComposeFile);
    }

    private static final Unit _init_$lambda$0(List $dependencies, StartDeployServerForOperatorInstanceTask $this$closureOf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$this$closureOf");
        Object[] objectArray = new Object[]{$dependencies};
        $this$closureOf.dependsOn(objectArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/StartDeployServerForOperatorInstanceTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

